package com.bxm.localnews.msg.config;

import com.google.common.collect.Maps;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

import java.util.Map;

@ConfigurationProperties(prefix = "message.dingtalk")
@Component
@Data
public class DingtalkProperties {
    /**
     * 默认场景,默认为运维监控
     */
    private String defaultScene = "ops";

    /**
     * 推送场景与钉钉机器人的映射关系
     * key：场景值，与推送参数相匹配
     * value：机器人地址
     */
    private Map<String, String> sceneMap = Maps.newHashMap();
}
