package com.bxm.localnews.msg.config;

import com.google.common.collect.Lists;
import lombok.Data;

import java.util.List;

/**
 * 消息类型配置信息
 *
 * @author liujia
 * @date 2020-07-08 21:38
 **/
@Data
public class MesssageTypeConfigInfo {
    /**
     * 消息类型
     */
    private String type;

    /**
     * 显示的名称
     */
    private String label;

    /**
     * 消息类型图标
     */
    private String icon;

    /**
     * 消息类型的显示顺序
     */
    private Integer index;

    /**
     * 消息类型对应的子类型（业务方定义的消息类型，在当前消息类型中进行聚合）
     */
    private List<String> subTypes = Lists.newArrayList();
}
