package com.bxm.localnews.msg.event.impl;

import com.bxm.localnews.mq.common.constant.RedisConfig;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.msg.event.UserEventService;
import com.bxm.localnews.msg.stream.MessageProvider;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.service.BaseService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

@Service
@Slf4j
public class UserEventServiceImpl extends BaseService implements UserEventService {

    private RedisHashMapAdapter redisHashMapAdapter;

    private RedisSetAdapter redisSetAdapter;

    private final MessageProvider messageProvider;

    public UserEventServiceImpl(RedisHashMapAdapter redisHashMapAdapter,
                                RedisSetAdapter redisSetAdapter,
                                MessageProvider messageProvider) {
        this.redisHashMapAdapter = redisHashMapAdapter;
        this.redisSetAdapter = redisSetAdapter;
        this.messageProvider = messageProvider;
    }

    @Override
    public void add(PushPayloadInfo payloadInfo) {
        Long userId = payloadInfo.getTargetUserId();
        if (null == userId) {
            log.error("注册用户事件必须传递userId在ext字段中");
            return;
        }

        //抹除用户ID
        payloadInfo.getExtend().remove("userId");

        //给与每一个消息唯一ID
        if (null == payloadInfo.getMsgId()) {
            payloadInfo.setMsgId(nextId());
        }

        KeyGenerator key = RedisConfig.USER_EVENTS.copy().appendKey(userId);
        KeyGenerator hasEventUserKey = RedisConfig.HAS_EVENT_SET;

        //同一种类型只保留最后一条(如后续有需求，针对不同的type可以给与随机的subkey)
        redisHashMapAdapter.put(key, String.valueOf(payloadInfo.getType()), payloadInfo);

        // 将有用户事件的ID放到缓存，与网关层保持一致
        redisSetAdapter.add(hasEventUserKey, userId);

        // 将用户ID放入到队列，用于同网关的信息同步
        messageProvider.userEvent(userId);
    }
}
