package com.bxm.localnews.msg.stream;

import org.springframework.cloud.stream.annotation.Input;
import org.springframework.cloud.stream.annotation.Output;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.SubscribableChannel;

/**
 * spring cloud steam的输入、输出通道定义
 * 需要配合 {@link MessageProvider} 激活，会根据注解生成对应名称spring bean
 * 同时配置的通道名称需要在配置文件中有对应的定义才能生效
 *
 * @author liujia
 * @date 2020-07-03 19:33
 **/
public interface MessageProcessor {

    /**
     * 用户之间单条消息推送
     */
    String SINGLE_PUSH_INPUT = "singlePushInput";

    /**
     * 将单个推送输出到MQ
     */
    String SINGLE_PUSH_OUTPUT = "singlePushOutput";

    /**
     * 运营群推消息，子任务消费
     */
    String BATCH_PUSH_INPUT = "batchPushInput";

    /**
     * 批量推送的输出通道
     */
    String BATCH_PUSH_OUTPUT = "batchPushOutput";

    /**
     * 用户事件
     */
    String USER_EVENT_OUTPUT = "userEventOutput";

    /**
     * 单条推送消息的定义通道
     *
     * @return 订阅通道
     */
    @Input(MessageProcessor.SINGLE_PUSH_INPUT)
    SubscribableChannel singlePushInput();

    /**
     * 单条推送消息的输出通道（应用到MQ）
     *
     * @return 输出通道
     */
    @Output(MessageProcessor.SINGLE_PUSH_OUTPUT)
    MessageChannel singlePushOutput();

    /**
     * 群推消息的定义通道
     *
     * @return 订阅通道
     */
    @Input(MessageProcessor.BATCH_PUSH_INPUT)
    SubscribableChannel batchPushInput();

    /**
     * 群推消息的输出通道
     *
     * @return 输出通道
     */
    @Output(MessageProcessor.BATCH_PUSH_OUTPUT)
    MessageChannel batchPushOutput();

    /**
     * 用户事件的输出通道
     *
     * @return 输出通道
     */
    @Output(MessageProcessor.USER_EVENT_OUTPUT)
    MessageChannel userEventOutput();
}
