package com.bxm.localnews.msg.stream;

import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.msg.param.PushMessageBucket;

/**
 * 消息输出代理服务类
 *
 * @author liujia
 * @date 2020-07-03 19:47
 **/
public interface MessageProvider {

    /**
     * 单条推送消息写入到消息队列
     *
     * @param message 推送的消息内容
     */
    void singlePush(PushMessage message);

    /**
     * 群体推送的消息写入到消息队列
     *
     * @param bucket 推送消息接收对象分桶
     */
    void batchPush(PushMessageBucket bucket);

    /**
     * 用户事件推送到消息队列
     *
     * @param userId 用户ID，表明该用户有事件待消费
     */
    void userEvent(Long userId);
}
