/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.msg.dingtalk.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.component.httpclient.service.HttpClientService;
import com.bxm.localnews.mq.common.param.DingtalkMessage;
import com.bxm.localnews.msg.config.DingtalkProperties;
import com.bxm.localnews.msg.dingtalk.DingtalkPushService;
import com.bxm.newidea.component.service.BaseService;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;

@Service
@RefreshScope
public class DingtalkPushServiceImpl
extends BaseService
implements DingtalkPushService {
    private final DingtalkProperties dingtalkProperties;
    private final HttpClientService httpClientService;

    @Autowired
    public DingtalkPushServiceImpl(DingtalkProperties dingtalkProperties, HttpClientService httpClientService) {
        this.dingtalkProperties = dingtalkProperties;
        this.httpClientService = httpClientService;
    }

    @Override
    public void pushNews(String content) {
        this.push(DingtalkMessage.builder().scene("news").content(content).build());
    }

    @Override
    public void pushIM(String content) {
        this.push(DingtalkMessage.builder().scene("im").content(content).build());
    }

    @Override
    public void push(DingtalkMessage message) {
        String webHookUrl = this.dingtalkProperties.getSceneMap().get(message.getScene());
        if (StringUtils.isBlank((String)webHookUrl)) {
            this.logger.info("\u63a8\u9001\u573a\u666f\u4e0d\u5b58\u5728\uff0c\u5c06\u6d88\u606f\u63a8\u9001\u5230\u8fd0\u7ef4\u76d1\u63a7\u7fa4");
            webHookUrl = this.dingtalkProperties.getSceneMap().get(this.dingtalkProperties.getDefaultScene());
        }
        JSONObject text = new JSONObject();
        text.put("content", (Object)message.getContent());
        JSONObject msg = new JSONObject();
        msg.put("msgtype", (Object)"text");
        msg.put("text", (Object)text);
        String response = this.httpClientService.doPostJson(webHookUrl, msg.toJSONString());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("push content:[{}],response:[{}]", (Object)JSON.toJSONString((Object)message), (Object)response);
        }
    }
}

