package com.bxm.localnews.msg.config;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

/**
 * 短信发送配置
 *
 * @author liujia 2018/7/26 16:37
 */
@Component
@ConfigurationProperties("message.config")
@Data
public class SmsProperties {

    /**
     * 示远短信发送请求路径
     */
    private String shiyuanUrl;

    /**
     * 示远短信账号
     */
    private String shiyuanAccount;

    /**
     * 示远短信密码
     */
    private String shiyuanPwd;

    /**
     * 235云通讯短信请求路径
     */
    private String chuanglanUrl;

    /**
     * 235云通讯短信账号
     */
    private String chuanglanAccount;

    /**
     * 235云通讯短信密码
     */
    private String chuanglanPwd;

    /**
     * 是否启用发送验证码
     */
    private Boolean enableSms;

    /**
     * 单个模版每个ip每天的限制发送量
     */
    private Integer ipLimitPerDay;

    /**
     * 单个模版每个号码每天的限制发送量
     */
    private Integer phoneLimitPerDay;

    /**
     * 默认采用的消息平台
     */
    private String operator = "shiyuan";
}
