package com.bxm.localnews.msg.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.msg.config.SmsProperties;
import com.bxm.localnews.msg.service.SmsSender;
import com.bxm.newidea.component.tools.SpringContextHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author zhaoyadong 2019/4/12 17:00
 * @desc
 */
public class ChuangLanSender implements SmsSender {

    private final static Logger log = LoggerFactory.getLogger(ShiyuanSender.class);

    private SmsProperties smsProperties;

    private SmsProperties getMessageProperties() {
        if (this.smsProperties == null) {
            this.smsProperties = SpringContextHolder.getBean(SmsProperties.class);
        }
        return this.smsProperties;
    }

    private ChuangLanApiImpl getApi() {
        return SpringContextHolder.getBean(ChuangLanApiImpl.class);
    }

    @Override
    public String[] send(String phone, String msg) {
        String result = "";
        this.smsProperties = this.getMessageProperties();
        try {
            result = getApi().batchSend(this.smsProperties.getChuanglanUrl(),
                    this.smsProperties.getChuanglanAccount(),
                    this.smsProperties.getChuanglanPwd(),
                    phone,
                    msg,
                    true,
                    "",
                    "");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        }
        return this.processResult(result);
    }

    /**
     * 短信提交响应返回数据：响应时间、消息id、状态码说明、状态码。无论发送的号码是多少，一个发送请求只返回一个messageid，
     * 如果响应的状态不是“0”，则状态说明不为空
     *
     * @param result 短信发送反馈结果
     * @return 转换后的短信
     */
    private String[] processResult(String result) {
        JSONObject jsonObject = JSONObject.parseObject(result);
        String code = jsonObject.getString("code");
        String msgId = jsonObject.getString("msgId");
        String errorMsg = jsonObject.getString("errorMsg");
        String[] re = new String[2];
        re[0] = code;
        if ("0".equals(code)) {
            re[1] = msgId + "---" + errorMsg;
        } else {
            re[1] = msgId;
        }
        return re;
    }
}
