package com.bxm.localnews.msg.service.impl;

import com.bxm.localnews.mq.common.param.WechatMpPushMessage;
import com.bxm.localnews.msg.enums.WxOpenIdEnum;
import com.bxm.localnews.msg.integration.PushTemplateMessageIntegrationService;
import com.bxm.localnews.msg.integration.UserAuthIntegrationService;
import com.bxm.localnews.msg.service.OfficialAccountPushService;
import com.bxm.localnews.msg.vo.UserAuth;
import com.bxm.newidea.component.vo.Message;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author lowi
 * @date 2021/1/7 17:17
 */
@Service
public class OfficialAccountPushServiceImpl implements OfficialAccountPushService {
    @Autowired
    private PushTemplateMessageIntegrationService pushTemplateMessageIntegrationService;
    @Autowired
    private UserAuthIntegrationService userAuthIntegrationService;

    @Override
    public Message push(WechatMpPushMessage wechatMpPushMessage) {
        //给公众号发消息，只查询公众号的类型openid
        UserAuth userAuth = userAuthIntegrationService.selectUserAuthByOpenId(wechatMpPushMessage.getUserId(), WxOpenIdEnum.OFFICIAL_ACCOUNT_OPENID.getType());
        if (userAuth == null) {
            return Message.build(false).setMessage("用户公众号openid不存在");
        }
        wechatMpPushMessage.setOid(userAuth.getIdentifier());
        return pushTemplateMessageIntegrationService.pushOfficialAccountMsg(wechatMpPushMessage);
    }
}
