package com.bxm.localnews.news.controller;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.param.HomeRecommendParam;
import com.bxm.localnews.news.service.RecommendService;
import com.bxm.localnews.news.vo.NewsMeta;
import com.bxm.localnews.news.vo.NewsRecommendParam;
import com.bxm.localnews.news.vo.NewsTopListParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "4-01 新闻首页接口", description = "新闻推荐和我的金币信息")
@RequestMapping("api/index")
@RestController
public class IndexController {

    private RecommendService recommendService;

    @Autowired
    public IndexController(RecommendService recommendService) {
        this.recommendService = recommendService;
    }

    @ApiOperation(value = "4-01-1 首页推荐列表", httpMethod = "GET")
    @GetMapping(value = "recommendList")
    public Json<NewsMeta> recommendList(NewsRecommendParam param) {
        return recommendService.execRecommend(param);
    }

    @ApiOperation(value = "4-01-2 查询首页新闻置顶列表", httpMethod = "GET")
    @GetMapping(value = "getTopNewsList")
    public Json<NewsMeta> getTopNewsList(NewsTopListParam param) {
        return recommendService.getTopNewsList(param);
    }


    @ApiOperation(value = "4-01-3 【新版】首页推荐列表", httpMethod = "GET",notes = "包含帖子，返回数据结果在以前接口的基础上着增加<帖子>实体")
    @GetMapping(value = "/mix/recommend")
    public Json<NewsMeta> listMixRecommend(HomeRecommendParam param, BasicParam basicParam) {
        param.setPageNum(param.getCurPage());
        return recommendService.listMixRecommend(param,basicParam);
    }

    @ApiOperation(value = "4-01-4 【新版】查询首页置顶列表", httpMethod = "GET",notes = "包含帖子，返回数据结果在以前接口的基础上着增加<帖子>实体")
    @GetMapping(value = "mix/top/recommend")
    public Json<NewsMeta> listTopMixRecommend(NewsTopListParam param) {
        return recommendService.getTopNewsList(param);
    }

}
