package com.bxm.localnews.news.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.dto.NewsReplyDTO;
import com.bxm.localnews.news.dto.NewsReplyDetailDTO;
import com.bxm.localnews.news.param.NewsReplyAddParam;
import com.bxm.localnews.news.param.NewsReplyLikeParam;
import com.bxm.localnews.news.param.NewsReplyParam;
import com.bxm.localnews.news.param.UserReplyParam;
import com.bxm.localnews.news.service.NewNewsReplyService;
import com.bxm.localnews.news.vo.MyReplysVO;
import com.bxm.localnews.news.vo.NewsReply;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

@Api(tags = "4-09 [新版]新闻回复接口", description = "对应的评论信息[新]")
@RequestMapping("/api")
@RestController
public class NewNewsReplyController {

    @Resource
    private NewNewsReplyService newNewsReplyService;

    @ApiOperation(value = "4-09-1 获取新闻、小视频、帖子的全部评论列表", notes = "根据业务id获取新闻或视频的全部评论列表", httpMethod = "GET")
    @RequestMapping(value = "news/newReply/list", method = RequestMethod.GET)
    public Json<PageWarper<NewsReplyDTO>> listReply(NewsReplyParam newsReplyParam,
                                                    @RequestParam(value = "curPage",required = false) Integer curPage) {
        //在版本初期客户端传的是curpage参数，所以为了向前兼容
        if (curPage == null) {
            curPage =1;
        }
        newsReplyParam.setPageNum(curPage);
        return ResultUtil.genSuccessResult(this.newNewsReplyService.queryReplyList(newsReplyParam));
    }

    @ApiOperation(value = "4-09-2 用户在新闻、小视频、帖子发表点评", notes = "用户在新闻或视频发表点评，需要传字段标识类型", httpMethod = "POST")
    @RequestMapping(value = "news/newReply", method = RequestMethod.POST)
    public Json<NewsReply> reply(NewsReplyAddParam newsReplyParam) {
        return Json.build(this.newNewsReplyService.doReply(newsReplyParam));
    }

    @ApiOperation(value = "4-09-3 用户发表的评论列表", notes = "不包含已删除的评论，包括新闻和视频", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "current", value = "当前页数[传这个参数],为了兼容前置版本，不改动此字段")
    })
    @RequestMapping(value = "news/newReply/myReply/list", method = RequestMethod.GET)
    public Json<PageWarper<MyReplysVO>> myReplys(UserReplyParam newsReplyParam,
                                                 @RequestParam(value = "current", required = false) Integer current) {
        if (current == null) {
            current = 1;
        }
        newsReplyParam.setPageNum(current);
        return ResultUtil.genSuccessResult(this.newNewsReplyService.selectMyReplys(newsReplyParam));
    }

    @ApiOperation(value = "4-09-4 删除我的评论", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "replyId", value = "回复id", required = true),
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "newsId", value = "新闻id", required = false)
    })
    @RequestMapping(value = "news/newReply/del", method = RequestMethod.GET)
    public Json<NewsReplyDTO> delMyReply(@RequestParam(value = "replyId") Long replyId,
                                         @RequestParam(value = "userId")Long userId,
                                         @RequestParam(value = "newsId",required = false) Long newsId) {
        return Json.build(this.newNewsReplyService.delMyReply(replyId,userId,newsId));
    }


    @ApiOperation(value = "4-09-5 回复点赞", notes = "对留言进行点赞")
    @PostMapping("news/newReply/like")
    public Json likeReply(NewsReplyLikeParam param) {
        return Json.build(newNewsReplyService.doProduceNewsReplyLike(param));
    }

    @ApiOperation(value = "4-09-6 根据id获取评论详情", notes = "获取某条评论的详情，包括新闻标题,跳转地址,新闻图片")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "replyId", value = "回复ID", required = true),
            @ApiImplicitParam(name = "type", value = "类型 1：新闻 2：视频 3:帖子", required = true),
            @ApiImplicitParam(name = "newsId", value = "新闻id", required = false)
    })
    @GetMapping("news/newReply/detail")
    public Json<NewsReplyDetailDTO> getReplyDetail(@RequestParam(value = "replyId") Long replyId,
                                                   @RequestParam(value = "userId") Long userId,
                                                   @RequestParam(value = "newsId",required = false) Long newsId) {
        return ResultUtil.genSuccessResult(newNewsReplyService.getNewsReplyDetailDTO(replyId, userId,newsId));
    }

}
