package com.bxm.localnews.news.controller;

import java.util.List;

import javax.annotation.Resource;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.news.dto.NewsCollectDTO;
import com.bxm.localnews.news.service.NewsCollectService;
import com.bxm.localnews.news.service.NewsInformService;
import com.bxm.localnews.news.vo.NewsCollect;
import com.bxm.localnews.news.vo.NewsInform;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags = "4-04 新闻信息收集接口", description = "包括新闻收藏和举报")
@RequestMapping("/api")
@RestController
public class NewsInformCollectController {

    @Resource
    private NewsCollectService collectService;

    @Resource
    private NewsInformService informService;

    @ApiOperation("4-04-1 获取我收藏的新闻列表")
    @RequestMapping(value = "news/collect/list", method = RequestMethod.GET)
    public Json<List<NewsCollectDTO>> getCollects(@RequestParam(value = "userId", required = true) Long userId, MPage page) {
        if (page == null) {
            page = new MPage();
        }
        page.checkPage();
        List<NewsCollectDTO> list = this.collectService.queryList(userId, page);
        return ResultUtil.genSuccessResultWithPage(list, page);
    }

    @ApiOperation("4-04-2 收藏或取消收藏新闻")
    @RequestMapping(value = "news/collectOrDelete", method = RequestMethod.GET)
    public Json collectNews(@RequestParam(value = "userId", required = true) Long userId,
                            @RequestParam(value = "newsId", required = true) Long newsId) {

        NewsCollect newsCollect = new NewsCollect(userId, newsId, (byte) 1);
        return this.collectService.collectNews(newsCollect);
    }

    @ApiOperation("4-04-3 新闻举报")
    @RequestMapping(value = "news/inform", method = RequestMethod.POST)
    public Json informNews(NewsInform newsInform) {
        return this.informService.informNews(newsInform);
    }

}
