package com.bxm.localnews.news.controller;

import java.util.Date;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.config.ForumProperties;
import com.bxm.localnews.news.dto.*;
import com.bxm.localnews.news.param.ForumPostCollectParam;
import com.bxm.localnews.news.param.ForumPostInformParam;
import com.bxm.localnews.news.param.ForumPostListQueryParam;
import com.bxm.localnews.news.param.ForumPostListUserQueryParam;
import com.bxm.localnews.news.service.ForumPostService;
import com.bxm.localnews.news.service.ForumService;
import com.bxm.localnews.news.service.ForumTopicService;
import com.bxm.localnews.news.vo.*;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.data.redis.core.RedisHash;
import org.springframework.web.bind.annotation.*;

@Api(tags = "4-10 社区版块相关信息获取")
@RestController
@RequestMapping("api/forum")
public class ForumController extends BaseController {

    @Resource
    private ForumPostService forumPostService;

    @Resource
    private ForumProperties forumProperties;

    @Resource
    private ForumTopicService forumTopicService;

    @Resource
    private ForumService forumService;

    @ApiOperation(value = "4-10-1 根据地区获取版块列表", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCode", value = "地区", required = true),
            @ApiImplicitParam(name = "size", value = "展示数量(默认为-1表示展示全部)")
    })
    @GetMapping(value = "getForumListByArea")
    public Json<List<ForumVo>> getForumListByArea(String areaCode,
                                                  @RequestParam(value = "size", required = false) Integer size,
                                                  Long userId, BasicParam basicParam) {
        return ResultUtil.genSuccessResult(forumService.listForum(areaCode, size, userId, basicParam));
    }

    @ApiOperation(value = "4-10-2 根据地区获取话题列表", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaCode", value = "地区", required = true),
            @ApiImplicitParam(name = "size", value = "展示数量(默认为-1表示展示全部)")
    })
    @GetMapping(value = "getTopicListByArea")
    public Json<List<TopicVo>> getTopicListByArea(String areaCode,
                                                  @RequestParam(value = "size", required = false) Integer size,
                                                  Long userId) {
        return ResultUtil.genSuccessResult(forumTopicService.listTopic(areaCode, size, userId));
    }

    @ApiOperation(value = "4-10-3 根据id获取版块", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码")
    })
    @GetMapping(value = "getForumById")
    public Json<ForumVo> getForumById(Long id, Long userId, String areaCode) {
        return ResultUtil.genSuccessResult(forumService.getForumDetail(id, userId, areaCode));
    }

    @ApiOperation(value = "4-10-4 根据id获取话题", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码")
    })
    @GetMapping(value = "getTopicById")
    public Json<TopicVo> getTopicById(Long id, Long userId, String areaCode) {
        if (null == id) {
            return ResultUtil.genFailedResult("未获取到话题!");
        }
        return ResultUtil.genSuccessResult(forumTopicService.getTopicDetail(id, userId, areaCode));
    }

    @ApiOperation(value = "4-10-5 根据版块或话题获取帖子列表", httpMethod = "GET")
    @GetMapping(value = "getPostPage")
    public Json<PageWarper<ForumPostVo>> getPostPage(ForumPostListQueryParam param, BasicParam basicParam) {
        return ResultUtil.genSuccessResult(forumPostService.listForumPost(param, basicParam));
    }

    @ApiOperation(value = "4-10-6 根据用户及类型获取帖子列表", httpMethod = "GET")
    @GetMapping(value = "getPostPageByUser")
    public Json<PageWarper<ForumPostVo>> getPostPageByUser(ForumPostListUserQueryParam param) {
        return ResultUtil.genSuccessResult(forumPostService.listForumPostByUser(param));
    }

    @ApiOperation(value = "4-10-7 根据id获取帖子详情", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "帖子id", required = true),
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "devcId", value = "设备id"),
            @ApiImplicitParam(name = "shareUserId", value = "转发者用户id"),
            @ApiImplicitParam(name = "areaCode", value = "地区编码")
    })
    @GetMapping(value = "getPostDetailById")
    public Json<ForumPostVo> getPostDetailById(Long id,
                                               Long userId,
                                               @RequestParam(value = "shareUserId", required = false) Long shareUserId,
                                               @RequestParam(value = "areaCode", required = false) String areaCode,
                                               BasicParam basicParam) {
        return ResultUtil.genSuccessResult(forumPostService.getForumPostDetail(id, userId, shareUserId, basicParam, areaCode));
    }

    @ApiOperation(value = "4-10-8 发布或编辑帖子", httpMethod = "POST", notes = "首次发帖奖励100小红花，每天10次发帖获得20小红花")
    @PostMapping(value = "public/createOrUpdatePost")
    public Json<ForumPostCreateDTO> createOrUpdatePost(@RequestBody ForumBasicVo forumBasicVo,BasicParam basicParam) {
        Message message = forumPostService.doCreateOrUpdatePost(forumBasicVo,basicParam, false);
        if (!message.isSuccess()) {
            return ResultUtil.genFailedResult(message.getMessages().get(0));
        }
        Map<String, Object> map = message.getParamMap();
        ForumPostCreateDTO forumPostCreateDTO = (ForumPostCreateDTO) map.getOrDefault("completeTaskAndPush", new ForumPostCreateDTO());
        return ResultUtil.genSuccessResult(forumPostCreateDTO);
    }

    @ApiOperation(value = "4-10-9 删除帖子", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "帖子id", required = true)
    })
    @PostMapping(value = "delete")
    public Json<Boolean> delete(Long id) {
        return ResultUtil.genSuccessResult(forumPostService.deleteForumPost(id));
    }

    @ApiOperation(value = "4-10-10 帖子点击次数+1", httpMethod = "POST", notes = "暂时不用")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "帖子id", required = true)
    })
    @PostMapping(value = "addClick")
    @Deprecated
    public Json addClick(Long id) {
        return ResultUtil.genSuccessResult();
    }

    @Deprecated
    @ApiOperation(value = "4-10-11 [旧版]点赞、取消点赞", notes = "点赞、取消点赞")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "postId", value = "帖子ID", required = true),
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "type", value = "0：取消点赞，1：点赞", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = true)
    })
    @PostMapping("like")
    public Json like(Long postId, Long userId, int type, String areaCode, BasicParam basicParam) {
        forumPostService.doLikeForumPost(userId, postId, type, areaCode, basicParam.getPlatform());
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation("4-10-12 收藏或取消收藏帖子")
    @RequestMapping(value = "collect", method = RequestMethod.POST)
    public Json collect(ForumPostCollectParam forumPostCollectParam) {
        this.forumPostService.doCollectForumPost(forumPostCollectParam);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation("4-10-13 帖子举报")
    @RequestMapping(value = "inform", method = RequestMethod.POST)
    public Json inform(ForumPostInformParam forumPostInformParam) {
        return ResultUtil.genSuccessResult(this.forumPostService.doInformForumPost(forumPostInformParam));
    }

    @ApiOperation(value = "4-10-14 帖子分享获得金币（返回类和新闻一样）", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "postId", value = "帖子ID", required = true),
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = true),
            @ApiImplicitParam(name = "type", value = "默认为1 类型：1 普通分享  2 小程序详情弹窗转发（每天一次可获得80红花）3.补签分享 4.任务点转发获取推荐池文章分享")
    })
    @RequestMapping(value = "share", method = RequestMethod.POST)
    public Json<NewsCompleTaskDTO> share(@RequestParam(value = "postId") Long postId,
                                         @RequestParam(value = "userId") Long userId,
                                         @RequestParam(value = "areaCode") String areaCode,
                                         @RequestParam(value = "type", required = false) Byte type,
                                         BasicParam basicParam) {
        if (null == type) {
            type = 1;
        }
        return ResultUtil.genSuccessResult(this.forumPostService.doShareForumPost(userId, postId, areaCode, type, basicParam.getPlatform()));
    }

    @ApiOperation(value = "4-10-15 帖子详情相关推荐", httpMethod = "GET", notes = "如果是15条，则5条本地新闻 10条帖子，如果是5条，则2条本地，3条帖子")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "postId", value = "帖子ID", required = true),
            @ApiImplicitParam(name = "userId", value = "用户ID"),
            @ApiImplicitParam(name = "areaCode", value = "地区编号"),
            @ApiImplicitParam(name = "size", value = "推荐个数")
    })
    @GetMapping(value = "detail/recommend")
    public Json<List<News4Client>> recommend(@RequestParam(value = "postId") Long postId,
                                             @RequestParam(value = "userId", required = false) Long userId,
                                             @RequestParam(value = "areaCode", required = false) String areaCode,
                                             @RequestParam(value = "size", required = false) Integer size,
                                             @RequestParam(value = "platform", required = false) Integer platform) {
        return ResultUtil.genSuccessResult(forumPostService.listPostDetailRecommend(postId, userId, size, areaCode,platform));
    }

    @ApiOperation(value = "4-10-17 [新版]帖子点赞", notes = "帖子点赞，无法取消点赞哦亲")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "postId", value = "帖子ID", required = true),
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "userNickname", value = "用户昵称", required = true),
            @ApiImplicitParam(name = "headImg", value = "用户头像", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = false)
    })
    @PostMapping("new/like")
    public Json<PostLikeDto> newLike(@RequestParam(value = "postId", required = true) Long postId,
                                     @RequestParam(value = "userId", required = true) Long userId,
                                     @RequestParam(value = "userNickname", required = false) String userNickname,
                                     @RequestParam(value = "headImg", required = false) String headImg,
                                     @RequestParam(value = "areaCode", required = true) String areaCode,
                                     BasicParam basicParam) {
        PostLikeDto postLikeDto = forumPostService.doLikeForumPost(postId, userId, areaCode, userNickname, headImg, basicParam.getPlatform());
        if (null != postLikeDto) {
            return ResultUtil.genSuccessResult(postLikeDto);
        } else {
            return ResultUtil.genFailedResult("");
        }
    }

    @ApiOperation(value = "4-10-18 根据帖子id获得点赞列表", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "postId", value = "帖子id", required = true),
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "devcId", value = "设备id", required = false)
    })
    @GetMapping(value = "getPostLikeDetailById")
    public Json<List<ForumPostLikeDTO>> getPostLikeDetailById(Long postId, Long userId, String devcId) {
        return ResultUtil.genSuccessResult(forumPostService.getPostLikeDetail(postId, userId, devcId));
    }

    @ApiOperation(value = "4-10-19 根据帖子id列表获取帖子列表")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "postIds", value = "帖子id列表，逗号分隔", required = true)
    })
    @GetMapping(value = "public/getPostListByIds")
    public Json<List<ForumPostVo>> getPostListByIds(String postIds) {
        return ResultUtil.genSuccessResult(forumPostService.getPostListByIds(postIds));
    }

    @ApiOperation(value = "4-10-20 获取现金奖励帖子轮播列表")
    @GetMapping(value = "getRewardPostList")
    public Json<List<ForumPostVo>> getRewardPostList() {
        return ResultUtil.genSuccessResult(forumPostService.getRewardPostList());
    }

    @ApiOperation(value = "4-10-21 获取爆料有奖页面地址")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "isLogin", value = "是否登录", required = false),
            @ApiImplicitParam(name = "userId", value = "用户id", required = false),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = false)
    })
    @GetMapping(value = "getPublishRewardUrl")
    public Json<String> getPublishRewardUrl(@RequestParam(value = "isLogin", required = false) String isLogin,
                                            @RequestParam(value = "userId", required = false) String userId,
                                            @RequestParam(value = "areaCode", required = false) String areaCode) {
        return ResultUtil.genSuccessResult(forumProperties.getPublishRewardUrl()
                + "?isLogin=" + isLogin + "&userId=" + userId + "&areaCode=" + areaCode);
    }

    @ApiOperation(value = "4-10-20 本地圈是否有内容更新 true有更新;false 无新内容更新")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "lastRequestTime", value = "用户id", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = true),
    })
    @GetMapping(value = "haveContentUpdate")
    public Json<Boolean> haveContentUpdate(Date lastRequestTime,String areaCode) {
        return ResultUtil.genSuccessResult(forumPostService.getContentUpdate(lastRequestTime,areaCode));
    }


}
