package com.bxm.localnews.news.controller;

import com.bxm.localnews.common.constant.RespCode;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.dto.KindDTO;
import com.bxm.localnews.news.service.NewsKindService;
import com.bxm.localnews.news.vo.NewsKind;
import com.bxm.newidea.component.vo.Message;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@Api(tags = "4-05 新闻频道接口", description = "用户对频道的操作")
@RequestMapping("api/kind")
@RestController
public class KindController {

    @Resource
    private NewsKindService newsKindService;

    @ApiOperation(value = "4-05-01 我的频道", httpMethod = "GET",notes = "2.1.0新接口需要传areaCode")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id"),
            @ApiImplicitParam(name = "areaName", value = "地区名称，如：富阳区"),
            @ApiImplicitParam(name = "areaCode", value = "地区编号，如：330111000000，2.1.0接口新增参数")})
    @GetMapping("myKinds")
    public Json<KindDTO> list(Long userId,
                              String areaName,
                              BasicParam basicParam,
                              @RequestParam(value = "areaCode",required = false) String areaCode) {
        return ResultUtil.genSuccessResult(newsKindService.getMyKindAndAllKind(userId, areaName, basicParam,areaCode));
    }

    @ApiOperation(value = "4-05-02 添加频道", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "kindId", value = "频道id", required = true)})
    @PostMapping("add")
    public Json save(Long userId, Integer kindId) {
        if (kindId == null) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "参数错误");
        }
        Message message = this.newsKindService.addUserKind(userId, kindId);
        if (!message.isSuccess()) {
            return ResultUtil.genFailedResult(RespCode.BAD_REQUEST, "重复添加");
        }
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "4-05-03 频道排序", notes = "对用户添加的频道进行排序", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "kindIds", value = "频道id数组", required = true),
            @ApiImplicitParam(name = "firstOpenType", value = "用户注册完之后第一次打开应用选择频道:1")})
    @PostMapping("resort")
    public Json resort(Long userId, Integer[] kindIds, String firstOpenType) {
        this.newsKindService.resortUserKind(userId, kindIds, firstOpenType);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "4-05-04 所有频道", httpMethod = "GET",notes = "2.1.0新接口需要传areaCode")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "areaName", value = "地区名称，如：富阳区"),
            @ApiImplicitParam(name = "areaCode", value = "地区编号，如：330111000000，2.1.0接口新增参数")})
    @GetMapping("newsKind")
    public Json<List<NewsKind>> listAll(@RequestParam(value = "areaCode",required = false) String areaCode,
                                        String areaName,
                                        BasicParam basicParam) {
        List<NewsKind> allKinds = this.newsKindService.selectAll(basicParam, areaName,areaCode);
        allKinds.removeIf(newsKind -> newsKind.getIsFix() == 1);
        return ResultUtil.genSuccessResult(allKinds);
    }
}
