package com.bxm.localnews.news.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.dto.ReplenishmentDTO;
import com.bxm.localnews.news.service.MixRecommendService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@Api(tags = "4-11 混合内容推荐库接口", description = "混合内容推荐库信息")
@RestController
public class MixRecommendController {

    @Autowired
    private MixRecommendService mixRecommendService;

    @ApiOperation(value = "4-11-1 获得推荐池中的最前的n条[新闻]或者[帖子]用于分享页轮播", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = true),
            @ApiImplicitParam(name = "type", value = "分享页类型（1:新闻 2:小视频 3:帖子）", required = true),
            @ApiImplicitParam(name = "size", value = "想要获取的条数", required = true)
    })
    @GetMapping(value = "/api/mix/carousel")
    public Json<List<ReplenishmentDTO>> listRecommend(@RequestParam(value = "userId", required = true) Long userId,
                                                @RequestParam(value = "areaCode", required = false) String areaCode,
                                                @RequestParam(value = "type", required = true) Byte type,
                                                @RequestParam(value = "size", required = true) Integer size) {

        List<ReplenishmentDTO> result = mixRecommendService.listRecommend(userId,areaCode,type,size);
        return ResultUtil.genSuccessResult(result);
    }

    @ApiOperation(value = "4-10-16 获得热门[帖子]或者[新闻]用于补签或者转发", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = true),
            @ApiImplicitParam(name = "type", value = "类型 1:任务点转发获取推荐池文章分享 3:补签分享 5.今日热闻", required = false),
    })
    @GetMapping(value = "/api/forum/hot")
    public Json<ReplenishmentDTO> recommend(@RequestParam(value = "userId", required = true) Long userId,
                                            @RequestParam(value = "areaCode",required = true) String areaCode,
                                            @RequestParam(value = "type",required = false) Byte type) {
        if (null==userId) {
            return ResultUtil.genFailedResult("未获取到用户信息!");
        }
        return ResultUtil.genSuccessResult(mixRecommendService.getHotPostOrNews(userId,areaCode,type));
    }
}
