package com.bxm.localnews.news.controller;

import java.util.List;

import javax.annotation.Resource;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.domain.NewsBlackMapper;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.dto.NewsLikeDTO;
import com.bxm.localnews.news.dto.PostLikeDto;
import com.bxm.localnews.news.param.ExecGoldParam;
import com.bxm.localnews.news.param.NewsLikeParam;
import com.bxm.localnews.news.param.NewsParam;
import com.bxm.localnews.news.service.NewsReadRewardService;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.vo.*;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

@Api(tags = "4-02 新闻相关信息获取")
@RestController
@RequestMapping("api/news")
public class NewsController {

    @Resource
    private NewsService newsService;

    @Resource
    private NewsBlackMapper newsBlackMapper;

    @Resource
    private NewsReadRewardService newsReadRewardService;

    @Deprecated
    @ApiOperation(value = "4-02-1 [旧版]获取新闻详情页跳转地址", httpMethod = "GET", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "新闻ID", required = true),
            @ApiImplicitParam(name = "userId", value = "用户ID"),
            @ApiImplicitParam(name = "type", value = "获取类型  1：详情地址   2：分享地址  " +
                    "3：搜索文章查看详情地址 4:广告分享链接（newsId为广告id）", required = true)
    })
    @GetMapping(value = "detailUrl")
    public Json<NewsUrlVo> getUrl(@RequestParam(value = "newsId") Long newsId,
                                  @RequestParam(value = "userId", required = false) Long userId,
                                  @RequestParam(value = "type") Byte type) {
        return this.newsService.getUrlAddress(newsId, userId, type);
    }

    @Deprecated
    @ApiOperation(value = "4-02-2 [旧版]新闻详情", notes = "获取新闻内容和详细信息", httpMethod = "GET")
    @GetMapping(value = "syDetail")
    public Json<NewsDetailVO> getNewsDetail(NewsParam newsParam, BasicParam basicParam) {
        return this.newsService.getNewsDetail(newsParam, basicParam);
    }

    @ApiOperation(value = "4-02-3 获取阅读文章获取金币", notes = "(app)阅读文章获取金币（满足条件调用）", httpMethod = "POST")
    @PostMapping(value = "read/gold")
    public Json<NewsGoldMeta> getGoldFormReading(ExecGoldParam execGoldParam) {
        return this.newsReadRewardService.execGetGold(execGoldParam);
    }

    @ApiOperation(value = "4-02-4 阅读文章返回时调用", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "新闻ID", required = true),
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "viewTime", value = "阅读时间", required = true),
            @ApiImplicitParam(name = "tabType", value = "是否读取到文章末尾 1：否   2：是", required = true),
            @ApiImplicitParam(name = "advertShow", value = "广告位是否展示出来 1：否  2：是", required = true)
    })
    @RequestMapping(value = "read/back", method = RequestMethod.POST)
    public Json doRecordNews(@RequestParam(value = "newsId") Long newsId,
                             @RequestParam(value = "userId") Long userId,
                             @RequestParam(value = "viewTime") Integer viewTime,
                             @RequestParam(value = "tabType") String tabType,
                             @RequestParam(value = "advertShow") String advertShow) {
        return this.newsService.doRecordNews(newsId, userId, viewTime, tabType, advertShow);
    }

    @ApiOperation(value = "4-02-5 新闻/视频详情推荐", notes = "包含文章下面的广告默认是列表第一条", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "新闻ID", required = true),
            @ApiImplicitParam(name = "userId", value = "用户ID", required = false),
            @ApiImplicitParam(name = "size", value = "详情推荐个数", required = false),
    })
    @RequestMapping(value = "detail/recommend", method = RequestMethod.GET)
    public Json<List<News4Client>> detailRecommend(@RequestParam(value = "newsId") Long newsId,
                                                   @RequestParam(value = "userId", required = false) Long userId,
                                                   @RequestParam(value = "areaCode", required = false) String areaCode,
                                                   @RequestParam(value = "size", required = false) Integer size,
                                                   @RequestParam(value = "platform", required = false,defaultValue = "0") Integer platform
                                                   ) {
        return this.newsService.listRecommendNews(newsId, userId, size, areaCode,platform);
    }

    @ApiOperation(value = "4-02-6 [旧版]组图推荐(暂未使用)", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "新闻ID", required = true)
    })
    @RequestMapping(value = "imgs/recommend", method = RequestMethod.GET)
    @Deprecated
    public Json<List<News4Client>> imgsRecommend(@RequestParam(value = "newsId") Long newsId) {
        return this.newsService.listRecommendNews4ImgNews(newsId);
    }

    @ApiOperation(value = "4-02-7 新闻分享", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "新闻ID", required = true),
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
            @ApiImplicitParam(name = "areaCode", value = "地区编码", required = true),
            @ApiImplicitParam(name = "type", value = "默认为1 类型：1.普通分享  2.小程序详情弹窗转发分享（每天一次可获得80红花） 3.补签分享 4.任务点转发获取推荐池文章分享 5.签到转发文章分享")

    })
    @RequestMapping(value = "share/gold", method = RequestMethod.POST)
    public Json<NewsCompleTaskDTO> shareNews(@RequestParam(value = "newsId") Long newsId,
                                             @RequestParam(value = "userId") Long userId,
                                             @RequestParam(value = "areaCode") String areaCode,
                                             @RequestParam(value = "type", required = false) Byte type,
                                             @RequestParam(value = "platform", required = false) int platform) {
        if (null == type) {
            type = 1;
        }
        return ResultUtil.genSuccessResult(newsReadRewardService.saveShareNews(newsId, userId, type,areaCode,platform));
    }

    @ApiOperation(value = "4-02-9 [旧版]视频上/下刷新", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "type", value = "类型", required = true),
            @ApiImplicitParam(name = "kindId", value = "新闻频道", required = true),
            @ApiImplicitParam(name = "cityName", value = "城市名称")
    })
    @RequestMapping(value = "refreshVideo", method = RequestMethod.GET)
    @Deprecated
    public Json<NewsMeta> refreshVideo(Long userId, Byte type, Integer kindId, String cityName) {
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "4-02-10 用户不感兴趣的文章", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "新闻ID", required = true),
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
            @ApiImplicitParam(name = "types", value = "原因列表：1：不感兴趣，2：看过了，3：内容重复，4：不喜欢该作者 5：内容质量差", required = true)
    })
    @PostMapping("black")
    public Json black(Long userId, Long newsId, Integer[] types) {
        if (newsId == null) {
            return ResultUtil.genFailedResult("参数错误");
        }
        this.newsBlackMapper.addBlack(userId, newsId, types != null ? JSON.toJSONString(types) : null);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "4-02-12 [旧版]获取热门搜索标题", httpMethod = "GET")
    @RequestMapping(value = "hotTitle", method = RequestMethod.GET)
    @Deprecated
    public Json<List<NewsSearchWord>> searchHotTitle() {
        return this.newsService.listHotTitle();
    }

    @ApiOperation(value = "4-02-13 [旧版]视频分类", httpMethod = "GET")
    @RequestMapping(value = "video/kinds", method = RequestMethod.GET)
    @Deprecated
    public Json<List<NewsKind>> videoKinds() {
        return this.newsService.listNewsKinds();
    }

    @ApiOperation(value = "4-02-14 [旧版]无效视频重新抓取接口(废弃)", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "新闻id", required = true)
    })
    @RequestMapping(value = "video/regain", method = RequestMethod.GET)
    @Deprecated
    public Json<FailVideo> getFailVideo(Long newsId) {
        return this.newsService.getFailVideo(newsId);
    }

    @ApiOperation(value = "4-02-15 点击次数+1", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "新闻id", required = true)
    })
    @RequestMapping(value = "click/add", method = RequestMethod.GET)
    @Deprecated
    public Json addClick(Long newsId) {
        return this.newsService.doSaveNewsClick(newsId);
    }

    @ApiOperation(value = "4-02-16 [新版]根据新闻id获取新闻内容详情", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "新闻id", required = true)
    })
    @RequestMapping(value = "getNewsDetailById", method = RequestMethod.GET)
    public Json<NewsDetailVO> getNewsDetailById(NewsParam newsParam, BasicParam basicParam) {
        return newsService.getNewsDetailById(newsParam, basicParam);
    }

    @ApiOperation(value = "4-02-17 新闻点赞接口", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "新闻ID", required = true),
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true),
    })
    @RequestMapping(value = "like", method = RequestMethod.POST)
    public Json<PostLikeDto> newsLike(NewsLikeParam newsLikeParam) {
        PostLikeDto postLikeDto = newsService.doNewsLike(newsLikeParam);
        if (null != postLikeDto) {
            return ResultUtil.genSuccessResult(postLikeDto);
        } else {
            return ResultUtil.genFailedResult("");
        }
    }


    @ApiOperation(value = "4-02-18 根据新闻id获得点赞列表", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newsId", value = "新闻id", required = true),
            @ApiImplicitParam(name = "userId", value = "用户id", required = true),
    })
    @GetMapping(value = "getNewLikeDetailById")
    public Json<List<NewsLikeDTO>> getPostLikeDetailById(Long newsId, Long userId) {
        List<NewsLikeDTO> list = newsService.listPostLikeByNewsId(newsId);
        return ResultUtil.genSuccessResult(list);
    }


}
