package com.bxm.localnews.news.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.news.dto.MyCollectDTO;
import com.bxm.localnews.news.dto.NewsCollectDTO;
import com.bxm.localnews.news.param.NewsCollectPageParam;
import com.bxm.localnews.news.param.NewsCollectParam;
import com.bxm.localnews.news.service.NewsCollectService;
import com.bxm.localnews.news.service.NewsInformService;
import com.bxm.localnews.news.vo.NewsCollect;
import com.bxm.localnews.news.vo.NewsInform;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.util.List;

@Api(tags = "4-04 新闻信息收集接口", description = "包括新闻收藏和举报")
@RequestMapping("/api")
@RestController
public class NewsInformCollectController {

    @Resource
    private NewsCollectService collectService;

    @Resource
    private NewsInformService informService;

    @ApiOperation("4-04-1 获取我收藏的新闻列表")
    @RequestMapping(value = "news/collect/list", method = RequestMethod.GET)
    public Json<List<NewsCollectDTO>> getCollects(@RequestParam(value = "userId", required = true) Long userId, MPage page) {
        if (page == null) {
            page = new MPage();
        }
        page.checkPage();
        List<NewsCollectDTO> list = this.collectService.queryList(userId, page);
        return ResultUtil.genSuccessResultWithPage(list, page);
    }

    @ApiOperation("4-04-2 收藏或取消收藏新闻")
    @RequestMapping(value = "news/collectOrDelete", method = RequestMethod.GET)
    public Json collectNews(NewsCollectParam newsCollectParam) {
        NewsCollect newsCollect = new NewsCollect(newsCollectParam.getUserId(), newsCollectParam.getNewsId(), (byte) 1);
        return this.collectService.collectNews(newsCollect,newsCollectParam.getPlatform(),newsCollectParam.getAreaCode());
    }

    @ApiOperation("4-04-3 新闻举报")
    @RequestMapping(value = "news/inform", method = RequestMethod.POST)
    public Json informNews(NewsInform newsInform) {
        return this.informService.informNews(newsInform);
    }

    @ApiOperation(value = "4-04-4 [新版]我的收藏", httpMethod = "GET")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true)
    })
    @GetMapping(value = "collect/list")
    public Json<PageWarper<MyCollectDTO>> listMyCollect(NewsCollectPageParam newsCollectPageParam) {
        return ResultUtil.genSuccessResult(collectService.listCollect(newsCollectPageParam));
    }

}
