package com.bxm.localnews.news.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.news.service.NewsRecordService;
import com.bxm.localnews.news.vo.NewsRecordVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * Created by Administrator on 2018/2/23 0023.
 */
@Api(tags = "4-07 新闻浏览记录", description = "浏览记录操作")
@RequestMapping("/api")
@RestController
public class NewsRecordController {

    @Resource
    private NewsRecordService newsRecordService;

    @ApiOperation(value = "4-07-01 获取浏览记录列表", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true)
    })
    @RequestMapping(value = "news/record/list", method = RequestMethod.GET)
    public Json<List<NewsRecordVO>> getRecords(@RequestParam(value = "userId") Long userId,
                                               MPage page) {
        if (page == null) {
            page = new MPage();
        }
        page.checkPage();
        List<NewsRecordVO> list = this.newsRecordService.queryRecordList(userId, page);
        return ResultUtil.genSuccessResultWithPage(list, page);
    }

    @ApiOperation(value = "4-07-02 清空阅读记录", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true)
    })
    @RequestMapping(value = "news/record/allDelete", method = RequestMethod.GET)
    public Json deleteById(@RequestParam(value = "userId") Long userId) {
        return this.newsRecordService.deleteById(userId);
    }

    @ApiOperation(value = "4-07-03 删除阅读记录", notes = "暂时没用")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户id", required = true)
    })
    @RequestMapping(value = "news/record/delete", method = RequestMethod.GET)
    public Json updateById(@RequestParam(value = "id") Long id) {
        return this.newsRecordService.updateById(id);
    }

}
