package com.bxm.localnews.news.controller;

import java.util.Date;

import com.bxm.localnews.common.annotation.TouTiaoAuth;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.news.config.NewsProperties;
import com.bxm.localnews.news.service.RecommendService;
import com.bxm.localnews.news.vo.NewsMeta;
import com.bxm.localnews.user.service.UserActiveService;
import com.bxm.localnews.user.service.UserRewardStatService;
import com.bxm.localnews.user.vo.CoinInfoModel;
import com.bxm.localnews.user.vo.GoldInfoModel;
import com.bxm.localnews.user.vo.MyCoin;
import com.bxm.localnews.user.vo.MyGold;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "4-01 新闻首页接口", description = "新闻推荐和我的金币信息")
@RequestMapping("api/index")
@RestController
public class IndexController {

    private RecommendService recommendService;

    private NewsProperties newsProperties;

    private UserRewardStatService userRewardStatService;

    private UserActiveService userActiveService;

    @Autowired
    public IndexController(RecommendService recommendService, UserRewardStatService userRewardStatService,
                           UserActiveService userActiveService) {
        this.recommendService = recommendService;
        this.userRewardStatService = userRewardStatService;
        this.userActiveService = userActiveService;
    }

    @ApiOperation(value = "4-01-1 首页推荐列表", httpMethod = "GET", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", paramType = "query", dataType = "Long", required = true),
            @ApiImplicitParam(name = "kindId", value = "频道ID", paramType = "query", dataType = "Long", required = true),
            @ApiImplicitParam(name = "type", value = "推荐方式，1：下拉刷新，2：上拉刷新；首次进首页算下拉刷新",
                    paramType = "query", dataType = "byte", allowableValues = "1, 2", required = true),
            @ApiImplicitParam(name = "pageSize", value = "拉取数量，默认20")
    })
    @GetMapping(value = "recommendList")
    @TouTiaoAuth
    public Json<NewsMeta> recommendList(@RequestParam(value = "userId") Long userId,
                                        @RequestParam(value = "kindId") Long kindId,
                                        @RequestParam(value = "type") Byte type,
                                        MPage page) {
        this.userActiveService.upsert(userId, new Date());
        Byte newsType = null;
        Integer isHot = null;

        if (this.isHotKind(kindId)) {
            isHot = this.newsProperties.getHotKindId() == kindId ? 1 : null;
            kindId = null;
            newsType = 1;
        }
        return this.recommendService.recommendNews(userId, kindId, isHot, type, page.checkPage().getPageSize(), newsType);
    }

    private boolean isHotKind(Long kindId) {
        return kindId != null &&
                (this.newsProperties.getRecommendKindId() == kindId
                        || this.newsProperties.getHotKindId() == kindId
                        || this.newsProperties.getMpKindId() == kindId);
    }

    @ApiOperation(value = "4-01-2 （每天）初始化redis中的值(未实现)", httpMethod = "GET", notes = "", hidden = true)
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    })
    @GetMapping(value = "install")
    @TouTiaoAuth
    @Deprecated
    public Object setDataToRedis(@RequestParam(value = "userId") Long userId) {
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value = "4-01-3 我的金币界面", httpMethod = "POST", notes = "客户端请求获取的数据需要进行筛选---" +
            "金币大于0为收入，小于0为支出")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    })
    @PostMapping(value = "myGold")
    @ResponseBody
    @TouTiaoAuth
    public Json<GoldInfoModel> myGold(@RequestParam(name = "userId") Long userId) {
        return this.userRewardStatService.myGoldStat(userId);
    }

    @ApiOperation(value = "4-01-4 我的昨日金币收益详情", httpMethod = "POST", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    })
    @RequestMapping(value = "goldDetail", method = RequestMethod.POST)
    @ResponseBody
    @TouTiaoAuth
    public Json<MyGold> goldDetail(@RequestParam(name = "userId") Long userId) {
        return this.userRewardStatService.myGoldDetail(userId);
    }

    @ApiOperation(value = "4-01-5 我的零钱界面", httpMethod = "POST", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    })
    @PostMapping(value = "myCoin")
    @ResponseBody
    @TouTiaoAuth
    public Json<CoinInfoModel> myCoin(@RequestParam(name = "userId") Long userId) {
        return this.userRewardStatService.myCoinStat(userId);
    }

    @ApiOperation(value = "4-01-6 我的昨日零钱收益详情", httpMethod = "POST", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "userId", value = "用户ID", required = true)
    })
    @PostMapping(value = "coinDetail")
    @ResponseBody
    @TouTiaoAuth
    public Json<MyCoin> coinDetail(@RequestParam(name = "userId") Long userId) {
        return this.userRewardStatService.myCoinDetail(userId);
    }

}
