/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.controller;

import com.bxm.localnews.common.annotation.TouTiaoAuth;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.service.RecommendService;
import com.bxm.localnews.news.vo.NewsMeta;
import com.bxm.localnews.news.vo.NewsRecommendParam;
import com.bxm.localnews.user.service.UserRewardStatService;
import com.bxm.localnews.user.vo.GoldInfoModel;
import com.bxm.localnews.user.vo.MyGold;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"4-01 \u65b0\u95fb\u9996\u9875\u63a5\u53e3"}, description="\u65b0\u95fb\u63a8\u8350\u548c\u6211\u7684\u91d1\u5e01\u4fe1\u606f")
@RequestMapping(value={"api/index"})
@RestController
public class IndexController {
    private RecommendService recommendService;
    private UserRewardStatService userRewardStatService;

    @Autowired
    public IndexController(RecommendService recommendService, UserRewardStatService userRewardStatService) {
        this.recommendService = recommendService;
        this.userRewardStatService = userRewardStatService;
    }

    @ApiOperation(value="4-01-1 \u9996\u9875\u63a8\u8350\u5217\u8868", httpMethod="GET", notes="")
    @GetMapping(value={"recommendList"})
    @TouTiaoAuth
    public Json<NewsMeta> recommendList(NewsRecommendParam param) {
        return this.recommendService.execRecommend(param);
    }

    @ApiOperation(value="4-01-2 \uff08\u6bcf\u5929\uff09\u521d\u59cb\u5316redis\u4e2d\u7684\u503c(\u672a\u5b9e\u73b0)", httpMethod="GET", notes="", hidden=true)
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)})
    @GetMapping(value={"install"})
    @TouTiaoAuth
    @Deprecated
    public Object setDataToRedis(@RequestParam(value="userId") Long userId) {
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value="4-01-3 \u6211\u7684\u91d1\u5e01\u754c\u9762", httpMethod="POST", notes="\u5ba2\u6237\u7aef\u8bf7\u6c42\u83b7\u53d6\u7684\u6570\u636e\u9700\u8981\u8fdb\u884c\u7b5b\u9009---\u91d1\u5e01\u5927\u4e8e0\u4e3a\u6536\u5165\uff0c\u5c0f\u4e8e0\u4e3a\u652f\u51fa")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)})
    @PostMapping(value={"myGold"})
    @ResponseBody
    @TouTiaoAuth
    public Json<GoldInfoModel> myGold(@RequestParam(name="userId") Long userId) {
        return this.userRewardStatService.myGoldStat(userId);
    }

    @ApiOperation(value="4-01-4 \u6211\u7684\u6628\u65e5\u91d1\u5e01\u6536\u76ca\u8be6\u60c5", httpMethod="POST", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)})
    @RequestMapping(value={"goldDetail"}, method={RequestMethod.POST})
    @ResponseBody
    @TouTiaoAuth
    public Json<MyGold> goldDetail(@RequestParam(name="userId") Long userId) {
        return this.userRewardStatService.myGoldDetail(userId);
    }
}

