/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.controller;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.activity.dto.NewShareGoldDTO;
import com.bxm.localnews.common.annotation.TouTiaoAuth;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.domain.NewsBlackMapper;
import com.bxm.localnews.news.param.ExecGoldParam;
import com.bxm.localnews.news.param.NewsParam;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.vo.FailVideo;
import com.bxm.localnews.news.vo.News4Client;
import com.bxm.localnews.news.vo.NewsDetailVO;
import com.bxm.localnews.news.vo.NewsGoldMeta;
import com.bxm.localnews.news.vo.NewsKind;
import com.bxm.localnews.news.vo.NewsMeta;
import com.bxm.localnews.news.vo.NewsSearchWord;
import com.bxm.localnews.news.vo.NewsUrlVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"4-02 \u65b0\u95fb\u76f8\u5173\u4fe1\u606f\u83b7\u53d6"}, description="\u83b7\u53d6\u65b0\u95fb\u8be6\u60c5")
@RestController
@RequestMapping(value={"api/news"})
public class NewsController {
    @Resource
    private NewsService newsService;
    @Resource
    private NewsBlackMapper newsBlackMapper;

    @ApiOperation(value="4-02-1 \u83b7\u53d6\u65b0\u95fb\u8be6\u60c5\u9875\u8df3\u8f6c\u5730\u5740", httpMethod="GET", notes="")
    @ApiImplicitParams(value={@ApiImplicitParam(name="newsId", value="\u65b0\u95fbID", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237ID"), @ApiImplicitParam(name="type", value="\u83b7\u53d6\u7c7b\u578b  1\uff1a\u8be6\u60c5\u5730\u5740   2\uff1a\u5206\u4eab\u5730\u5740  3\uff1a\u641c\u7d22\u6587\u7ae0\u67e5\u770b\u8be6\u60c5\u5730\u5740 4:\u5e7f\u544a\u5206\u4eab\u94fe\u63a5\uff08newsId\u4e3a\u5e7f\u544aid\uff09", required=true)})
    @GetMapping(value={"detailUrl"})
    public Json<NewsUrlVo> getUrl(@RequestParam(value="newsId") Long newsId, @RequestParam(value="userId", required=false) Long userId, @RequestParam(value="type") Byte type) {
        return this.newsService.getUrl(newsId, userId, type);
    }

    @ApiOperation(value="4-02-2 \u65b0\u95fb\u8be6\u60c5", notes="\u83b7\u53d6\u65b0\u95fb\u5185\u5bb9\u548c\u8be6\u7ec6\u4fe1\u606f", httpMethod="GET")
    @GetMapping(value={"syDetail"})
    public Json<NewsDetailVO> syDetail(NewsParam newsParam) {
        return this.newsService.execGetSyDetail(newsParam);
    }

    @ApiOperation(value="4-02-3 \u83b7\u53d6\u9605\u8bfb\u6587\u7ae0\u83b7\u53d6\u91d1\u5e01", notes="(app)\u9605\u8bfb\u6587\u7ae0\u83b7\u53d6\u91d1\u5e01\uff08\u6ee1\u8db3\u6761\u4ef6\u8c03\u7528\uff09", httpMethod="POST")
    @PostMapping(value={"read/gold"})
    public Json<NewsGoldMeta> getGold(ExecGoldParam execGoldParam) {
        return this.newsService.execGetGold(execGoldParam);
    }

    @ApiOperation(value="4-02-4 (app)\u9605\u8bfb\u6587\u7ae0\u8fd4\u56de\u65f6\u8c03\u7528", notes="", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="newsId", value="\u65b0\u95fbID", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true), @ApiImplicitParam(name="viewTime", value="\u9605\u8bfb\u65f6\u95f4", required=true), @ApiImplicitParam(name="tabType", value="\u662f\u5426\u8bfb\u53d6\u5230\u6587\u7ae0\u672b\u5c3e 1\uff1a\u5426   2\uff1a\u662f", required=true), @ApiImplicitParam(name="advertShow", value="\u5e7f\u544a\u4f4d\u662f\u5426\u5c55\u793a\u51fa\u6765 1\uff1a\u5426  2\uff1a\u662f", required=true)})
    @RequestMapping(value={"read/back"}, method={RequestMethod.POST})
    public Json getBack(@RequestParam(value="newsId") Long newsId, @RequestParam(value="userId") Long userId, @RequestParam(value="viewTime") Integer viewTime, @RequestParam(value="tabType") String tabType, @RequestParam(value="advertShow") String advertShow) {
        return this.newsService.getBack(newsId, userId, viewTime, tabType, advertShow);
    }

    @ApiOperation(value="4-02-5 \u65b0\u95fb/\u89c6\u9891\u8be6\u60c5\u63a8\u8350", notes="\u5305\u542b\u6587\u7ae0\u4e0b\u9762\u7684\u5e7f\u544a\u9ed8\u8ba4\u662f\u5217\u8868\u7b2c\u4e00\u6761", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="newsId", value="\u65b0\u95fbID", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=false)})
    @RequestMapping(value={"detail/recommend"}, method={RequestMethod.GET})
    public Json<List<News4Client>> detailRecommend(@RequestParam(value="newsId") Long newsId, @RequestParam(value="userId", required=false) Long userId) {
        return this.newsService.queryRecommendNews(newsId, userId);
    }

    @ApiOperation(value="4-02-6 \u7ec4\u56fe\u63a8\u8350", notes="", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="newsId", value="\u65b0\u95fbID", required=true)})
    @RequestMapping(value={"imgs/recommend"}, method={RequestMethod.GET})
    public Json<List<News4Client>> imgsRecommend(@RequestParam(value="newsId") Long newsId) {
        return this.newsService.queryRecommendNews4ImgNews(newsId);
    }

    @ApiOperation(value="4-02-7 \u65b0\u95fb\u5206\u4eab\u6210\u529f\u91d1\u5e01\u8d60\u9001", notes="", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="newsId", value="\u65b0\u95fbID", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true)})
    @RequestMapping(value={"share/gold"}, method={RequestMethod.POST})
    @TouTiaoAuth
    public Json<NewShareGoldDTO> shareNews(@RequestParam(value="newsId") Long newsId, @RequestParam(value="userId") Long userId) {
        return this.newsService.saveShareNews(newsId, userId);
    }

    @ApiOperation(value="4-02-9 \u89c6\u9891\u4e0a/\u4e0b\u5237\u65b0", notes="", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true), @ApiImplicitParam(name="type", value="\u7c7b\u578b", required=true), @ApiImplicitParam(name="kindId", value="\u65b0\u95fb\u9891\u9053", required=true), @ApiImplicitParam(name="cityName", value="\u57ce\u5e02\u540d\u79f0")})
    @RequestMapping(value={"refreshVideo"}, method={RequestMethod.GET})
    public Json<NewsMeta> refreshVideo(Long userId, Byte type, Integer kindId, String cityName) {
        return this.newsService.refreshVideo(userId, type, kindId);
    }

    @ApiOperation(value="4-02-10 \u7528\u6237\u4e0d\u611f\u5174\u8da3\u7684\u6587\u7ae0", notes="", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="newsId", value="\u65b0\u95fbID", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true), @ApiImplicitParam(name="types", value="\u539f\u56e0\u5217\u8868\uff1a1\uff1a\u4e0d\u611f\u5174\u8da3\uff0c2\uff1a\u770b\u8fc7\u4e86\uff0c3\uff1a\u5185\u5bb9\u91cd\u590d\uff0c4\uff1a\u4e0d\u559c\u6b22\u8be5\u4f5c\u8005 5\uff1a\u5185\u5bb9\u8d28\u91cf\u5dee", required=true)})
    @TouTiaoAuth
    @PostMapping(value={"black"})
    public Json black(Long userId, Long newsId, Integer[] types) {
        if (newsId == null) {
            return ResultUtil.genFailedResult((String)"\u53c2\u6570\u9519\u8bef");
        }
        this.newsBlackMapper.addBlack(userId, newsId, types != null ? JSON.toJSONString((Object)types) : null);
        return ResultUtil.genSuccessResult();
    }

    @ApiOperation(value="4-02-12 \u83b7\u53d6\u70ed\u95e8\u641c\u7d22\u6807\u9898", notes="", httpMethod="GET")
    @RequestMapping(value={"hotTitle"}, method={RequestMethod.GET})
    public Json<List<NewsSearchWord>> searchHotTitle() {
        return this.newsService.searchHotTitle();
    }

    @ApiOperation(value="4-02-13 \u89c6\u9891\u5206\u7c7b", notes="", httpMethod="GET")
    @RequestMapping(value={"video/kinds"}, method={RequestMethod.GET})
    public Json<List<NewsKind>> videoKinds() {
        return this.newsService.searchKinds();
    }

    @ApiOperation(value="4-02-14 \u65e0\u6548\u89c6\u9891\u91cd\u65b0\u6293\u53d6\u63a5\u53e3", notes="", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="newsId", value="\u65b0\u95fbid", required=true)})
    @RequestMapping(value={"video/regain"}, method={RequestMethod.GET})
    public Json<FailVideo> getFailVideo(Long newsId) {
        return this.newsService.getFailVideo(newsId);
    }

    @ApiOperation(value="4-02-15 \u70b9\u51fb\u6b21\u6570+1", notes="", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="newsId", value="\u65b0\u95fbid", required=true)})
    @RequestMapping(value={"click/add"}, method={RequestMethod.GET})
    public Json addClick(Long newsId) {
        return this.newsService.addClick(newsId);
    }
}

