/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.news.dto.NewsCollectDTO;
import com.bxm.localnews.news.service.NewsCollectService;
import com.bxm.localnews.news.service.NewsInformService;
import com.bxm.localnews.news.vo.NewsCollect;
import com.bxm.localnews.news.vo.NewsInform;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"4-04 \u65b0\u95fb\u4fe1\u606f\u6536\u96c6\u63a5\u53e3"}, description="\u5305\u62ec\u65b0\u95fb\u6536\u85cf\u548c\u4e3e\u62a5")
@RequestMapping(value={"/api"})
@RestController
public class NewsInformCollectController {
    @Resource
    private NewsCollectService collectService;
    @Resource
    private NewsInformService informService;

    @ApiOperation(value="4-04-1 \u83b7\u53d6\u6211\u6536\u85cf\u7684\u65b0\u95fb\u5217\u8868")
    @RequestMapping(value={"news/collect/list"}, method={RequestMethod.GET})
    public Json<List<NewsCollectDTO>> getCollects(@RequestParam(value="userId", required=true) Long userId, MPage page) {
        if (page == null) {
            page = new MPage();
        }
        page.checkPage();
        List list = this.collectService.queryList(userId, page);
        return ResultUtil.genSuccessResultWithPage((Object)list, (MPage)page);
    }

    @ApiOperation(value="4-04-2 \u6536\u85cf\u6216\u53d6\u6d88\u6536\u85cf\u65b0\u95fb")
    @RequestMapping(value={"news/collectOrDelete"}, method={RequestMethod.GET})
    public Json collectNews(@RequestParam(value="userId", required=true) Long userId, @RequestParam(value="newsId", required=true) Long newsId) {
        NewsCollect newsCollect = new NewsCollect(userId, newsId, Byte.valueOf((byte)1));
        return this.collectService.collectNews(newsCollect);
    }

    @ApiOperation(value="4-04-3 \u65b0\u95fb\u4e3e\u62a5")
    @RequestMapping(value={"news/inform"}, method={RequestMethod.POST})
    public Json informNews(NewsInform newsInform) {
        return this.informService.informNews(newsInform);
    }
}

