/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.controller;

import com.bxm.localnews.common.annotation.TouTiaoAuth;
import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.news.dto.NewsReplyDTO;
import com.bxm.localnews.news.service.NewsReplyService;
import com.bxm.localnews.news.vo.MyReceiveReplysVO;
import com.bxm.localnews.news.vo.MyReplysVO;
import com.bxm.localnews.news.vo.NewsReply;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"4-03 \u65b0\u95fb\u56de\u590d\u63a5\u53e3"}, description="\u5bf9\u5e94\u7684\u8bc4\u8bba\u4fe1\u606f")
@RequestMapping(value={"/api"})
@RestController
public class NewsReplyController {
    @Resource
    private NewsReplyService newsReplyService;

    @ApiOperation(value="4-03-1 \u83b7\u53d6\u5168\u90e8\u8bc4\u8bba\u5217\u8868", notes="", httpMethod="GET")
    @ApiImplicitParam(name="newsId", value="\u65b0\u95fbID")
    @RequestMapping(value={"news/reply/list"}, method={RequestMethod.GET})
    public Json<List<NewsReplyDTO>> getReplys(@RequestParam(value="newsId") Long newsId, MPage page) {
        page.checkPage();
        List list = this.newsReplyService.queryReplyList(newsId, page);
        return ResultUtil.genSuccessResultWithPage((Object)list, (MPage)page);
    }

    @ApiOperation(value="4-03-2 \u7528\u6237\u53d1\u8868\u70b9\u8bc4", notes="", httpMethod="POST")
    @TouTiaoAuth
    @RequestMapping(value={"news/reply"}, method={RequestMethod.POST})
    public Json reply(NewsReply newsReply) {
        return this.newsReplyService.reply(newsReply);
    }

    @ApiOperation(value="4-03-3 \u6211\u53d1\u8868\u7684\u8bc4\u8bba\u5217\u8868", notes="\u4e0d\u5305\u542b\u5df2\u5220\u9664\u7684\u8bc4\u8bba", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true), @ApiImplicitParam(name="current", value="current")})
    @RequestMapping(value={"news/myReply/list"}, method={RequestMethod.GET})
    public Json<List<MyReplysVO>> myReplys(@RequestParam(value="userId") Long userId, MPage page, @RequestParam(value="current", required=false) Integer current) {
        if (current == null) {
            current = 1;
        }
        page.setCurPage(current);
        page.checkPage();
        List list = this.newsReplyService.selectMyReplys(userId, page);
        return ResultUtil.genSuccessResultWithPage((Object)list, (MPage)page);
    }

    @ApiOperation(value="4-03-4 \u5220\u9664\u6211\u7684\u8bc4\u8bba", notes="", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="replyId", value="\u56de\u590did", required=true)})
    @RequestMapping(value={"news/del/myReply"}, method={RequestMethod.GET})
    public Json delMyReply(@RequestParam(value="replyId") Long replyId) {
        return this.newsReplyService.delMyReply(replyId);
    }

    @ApiOperation(value="4-03-5 \u6211\u6536\u5230\u7684\u8bc4\u8bba\u5217\u8868", notes="", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="\u7528\u6237id", required=true), @ApiImplicitParam(name="current", value="current")})
    @RequestMapping(value={"news/receiveReply/list"}, method={RequestMethod.GET})
    public Json<List<MyReceiveReplysVO>> myReceiveReplys(@RequestParam(value="userId") Long userId, MPage page, @RequestParam(value="current", required=false) Integer current) {
        if (current == null) {
            current = 1;
        }
        page.setCurPage(current);
        page.checkPage();
        List list = this.newsReplyService.myReceiveReplys(userId, page);
        return ResultUtil.genSuccessResultWithPage((Object)list, (MPage)page);
    }
}

