/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.dto.VideoDto;
import com.bxm.localnews.news.dto.VideoReplyDto;
import com.bxm.localnews.news.param.VideoBlackParam;
import com.bxm.localnews.news.param.VideoInformParam;
import com.bxm.localnews.news.param.VideoQueryParam;
import com.bxm.localnews.news.param.VideoReplyLikeParam;
import com.bxm.localnews.news.param.VideoReplyListQueryParam;
import com.bxm.localnews.news.param.VideoReplyParam;
import com.bxm.localnews.news.param.VideoShareParam;
import com.bxm.localnews.news.param.VideoViewParam;
import com.bxm.localnews.news.service.VideoBlackService;
import com.bxm.localnews.news.service.VideoLikeService;
import com.bxm.localnews.news.service.VideoRecommendService;
import com.bxm.localnews.news.service.VideoReplyService;
import com.bxm.localnews.news.service.VideoShareService;
import com.bxm.localnews.news.service.VideoViewService;
import com.bxm.newidea.component.controller.BaseController;
import com.bxm.newidea.component.vo.Message;
import com.bxm.newidea.component.vo.PageWarper;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"4-08 \u89c6\u9891\u76f8\u5173\u63a5\u53e3"}, description="\u89c6\u9891\u83b7\u53d6\uff0c\u89c6\u9891\u70b9\u8d5e\u3001\u8bc4\u8bba\u7b49\u76f8\u5173\u63a5\u53e3")
@RestController
@RequestMapping(value={"api/video"})
public class VideoController
extends BaseController {
    private final VideoViewService videoViewService;
    private final VideoReplyService videoReplyService;
    private final VideoBlackService videoBlackService;
    private final VideoShareService videoShareService;
    private VideoRecommendService videoRecommendService;
    private VideoLikeService videoLikeService;

    @Autowired
    public VideoController(VideoRecommendService videoRecommendService, VideoLikeService videoLikeService, VideoViewService videoViewService, VideoReplyService videoReplyService, VideoBlackService videoBlackService, VideoShareService videoShareService) {
        this.videoRecommendService = videoRecommendService;
        this.videoLikeService = videoLikeService;
        this.videoViewService = videoViewService;
        this.videoReplyService = videoReplyService;
        this.videoBlackService = videoBlackService;
        this.videoShareService = videoShareService;
    }

    @ApiOperation(value="4-08-1 \u83b7\u53d6\u89c6\u9891\u5217\u8868", notes="\u4e3a\u6307\u5b9a\u7684\u7528\u6237\u63a8\u8350\u4e00\u5b9a\u91cf\u7684\u89c6\u9891\u6570\u91cf,\u5982\u679c\u8fd4\u56de\u7684\u7ed3\u679c\u6570\u7ec4\u957f\u5ea6\u4e3a0\uff0c\u8868\u793a\u6ca1\u6709\u66f4\u591a\u7684\u89c6\u9891\u53ef\u4ee5\u63a8\u8350")
    @GetMapping(value={"list"})
    public Json<List<VideoDto>> getVideo(VideoQueryParam param) {
        return Json.build((Object)this.videoRecommendService.execRecommend(param));
    }

    @ApiOperation(value="4-08-2 \u5c4f\u853d\u89c6\u9891", notes="\u7528\u6237\u5bf9\u89c6\u9891\u4e0d\u611f\u5174\u8da3\uff0c\u6216\u4e3e\u62a5\u89c6\u9891")
    @PostMapping(value={"black"})
    public Json black(VideoBlackParam param) {
        return Json.build((Message)this.videoBlackService.produceVideoReply(param));
    }

    @ApiOperation(value="4-08-3 \u70b9\u8d5e\u3001\u53d6\u6d88\u70b9\u8d5e\u89c6\u9891", notes="\u89c6\u9891\u70b9\u8d5e\u3001\u53d6\u6d88\u70b9\u8d5e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="videoId", value="\u89c6\u9891ID", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="type", value="0\uff1a\u53d6\u6d88\u70b9\u8d5e\uff0c1\uff1a\u70b9\u8d5e")})
    @PostMapping(value={"like"})
    public Json like(Long videoId, Long userId, int type) {
        return Json.build((Message)this.videoLikeService.save(videoId, userId, type));
    }

    @ApiOperation(value="4-08-4 \u83b7\u53d6\u56de\u590d\u5217\u8868", notes="\u83b7\u53d6\u5355\u4e2a\u89c6\u9891\u4e0b\u7684\u56de\u590d\u6e05\u5355,\u5982\u679c\u8fd4\u56deresult\u6570\u7ec4\u4e3a\u7a7a\u6216\u5c0f\u4e8ePageSize\u5219\u8868\u793a\u65e0\u66f4\u591a\u56de\u590d")
    @GetMapping(value={"reply/list"})
    public Json<PageWarper<VideoReplyDto>> getReplies(VideoReplyListQueryParam param) {
        return ResultUtil.genSuccessResult((Object)this.videoReplyService.queryByPageSize(param));
    }

    @ApiOperation(value="4-08-5 \u89c6\u9891\u56de\u590d", notes="\u89c6\u9891\u7559\u8a00\uff0c\u6216\u5bf9\u56de\u590d\u8fdb\u884c\u56de\u590d")
    @PostMapping(value={"reply"})
    public Json reply(VideoReplyParam param) {
        return Json.build((Message)this.videoReplyService.replyVideo(param));
    }

    @ApiOperation(value="4-08-6 \u56de\u590d\u70b9\u8d5e", notes="\u5bf9\u7559\u8a00\u8fdb\u884c\u70b9\u8d5e")
    @ApiImplicitParams(value={@ApiImplicitParam(name="replyId", value="\u56de\u590dID", required=true), @ApiImplicitParam(name="userId", value="\u7528\u6237ID", required=true), @ApiImplicitParam(name="type", value="0\uff1a\u53d6\u6d88\u70b9\u8d5e\uff0c1\uff1a\u70b9\u8d5e")})
    @PostMapping(value={"like/reply"})
    public Json likeReply(VideoReplyLikeParam param) {
        return Json.build((Message)this.videoReplyService.produceVideoReplyLike(param));
    }

    @ApiOperation(value="4-08-7 \u89c6\u9891\u6d4f\u89c8\u8bb0\u5f55", notes="\u7528\u6237\u6d4f\u89c8\u89c6\u9891\u7ed3\u675f\u540e\u8c03\u7528\uff0c\u4fdd\u5b58\u7528\u6237\u6d4f\u89c8\u8bb0\u5f55")
    @PostMapping(value={"view"})
    public Json view(VideoViewParam param) {
        return Json.build((Message)this.videoViewService.produceVideoView(param));
    }

    @ApiOperation(value="4-08-8 \u89c6\u9891\u5206\u4eab", notes="\u7528\u6237\u5206\u4eab\u89c6\u9891\u7ed3\u675f\u540e\u8c03\u7528\uff0c\u4fdd\u5b58\u7528\u6237\u5206\u4eab\u8bb0\u5f55")
    @PostMapping(value={"share"})
    public Json share(VideoShareParam param) {
        return Json.build((Message)this.videoShareService.produceVideoShare(param));
    }

    @ApiOperation(value="4-08-9 \u89c6\u9891\u4e3e\u62a5", notes="\u7528\u6237\u53ef\u4ee5\u5728\u89c6\u9891\u8be6\u60c5\u9875\u9762\u5bf9\u89c6\u9891\u8fdb\u884c\u4e3e\u62a5")
    @PostMapping(value={"inform"})
    public Json inform(VideoInformParam param) {
        return Json.build((Message)Message.build((Message)this.videoBlackService.informVideo(param)));
    }
}

