/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.enums;

import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import java.util.Arrays;
import java.util.stream.Stream;

public enum TaskEnum {
    READ_PUSH_ARTICLE(11, "\u9605\u8bfb\u63a8\u9001\u65b0\u95fb", new String[]{"otherReward", "goldReward"}, null, null),
    REGISTER(18, "\u7528\u6237\u6ce8\u518c", new String[]{"moneyReward", "redPacketMoney"}, null, null),
    SIGN_DAILY(20, "\u6bcf\u65e5\u7b7e\u5230", new String[]{"otherReward", "goldReward"}, null, null),
    EXCHANGE_GOODS(27, "\u5c0f\u7ea2\u82b1\u5151\u6362\u5546\u54c1", new String[]{"otherReward", "goldReward"}, null, null),
    STORE_ADD_BALANCE(30, "\u79ef\u5206\u5546\u57ce\u6dfb\u52a0\u5c0f\u7ea2\u82b1", new String[]{"otherReward", "goldReward"}, null, null),
    TASK_NEWS_SHARE(9, "\u5206\u4eab\u5185\u5bb9", new String[]{"shareArtical", "goldReward"}, PushMessageEnum.TASK_COMPLETED, null),
    TASK_NEWS_READ(10, "\u770b\u65b0\u95fb", new String[]{"readReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, null),
    TASK_INVITED_FRIEND(31, "\u9080\u8bf7\u597d\u53cb", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, null),
    TASK_VIDEO_READ(32, "\u770b\u89c6\u9891", new String[]{"readReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, null),
    TASK_IMPROVE_INFO(34, "\u5b8c\u5584\u4e2a\u4eba\u8d44\u6599\u8d5a\u5c0f\u7ea2\u82b1", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, null),
    TASK_ACTIVATION_VIP(35, "\u6fc0\u6d3bVIP\u4e00\u5e74", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, null),
    TASK_FIRST_POST_INTIVATION(36, "\u9996\u6b21\u53d1\u672c\u5730\u5708\u8d5a\u5c0f\u7ea2\u82b1", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, null),
    TASK_POST_INTIVATION(37, "\u53d1\u672c\u5730\u5708\u8d5a\u5c0f\u7ea2\u82b1", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, null),
    TASK_COLLECT_APPLET_MINI(38, "\u6536\u85cf\u672c\u5730\u4e07\u4e8b\u901a\u5c0f\u7a0b\u5e8f", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, "red"),
    TASK_FOCUS_WECAHT(39, "\u5173\u6ce8\u5fae\u4fe1\u516c\u4f17\u53f7", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, "red"),
    TASK_JOIN_WECHAT(40, "\u52a0\u5165\u4fbf\u6c11\u5fae\u4fe1\u7fa4", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, "green"),
    TASK_INVITE_FRIEND(41, "\u9080\u8bf7\u672c\u5730\u7684\u4eb2\u670b\u597d\u53cb", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, "green"),
    TASK_EVERYDAY_SHARE(42, "\u6bcf\u65e5\u9996\u6b21\u5206\u4eab\u65b0\u95fb/\u5e16\u5b50", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, "red"),
    TASK_COMMENT_NEWS(43, "\u53d1\u8bc4\u8bba\u8d5a\u5c0f\u7ea2\u82b1", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, "red"),
    TASK_FIRST_BROWSE(44, "\u8f6c\u53d1\u8d5a\u5c0f\u7ea2\u82b1", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, "red"),
    TASK_FIRST_LOGIN(45, "\u65b0\u7528\u6237\u9996\u6b21\u767b\u9646", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, null),
    TASK_SIGN_SHARE(46, "\u7b7e\u5230\u8f6c\u53d1\u5956\u52b1", new String[]{"otherReward", "goldReward"}, PushMessageEnum.TASK_COMPLETED, null);

    private byte type;
    private String desc;
    private String[] tableColumn;
    private PushMessageEnum pushMessageEnum;
    private String color;

    private TaskEnum(byte type, String desc, String[] tableColumn, PushMessageEnum pushMessageEnum, String color) {
        this.type = type;
        this.desc = desc;
        this.tableColumn = tableColumn;
        this.pushMessageEnum = pushMessageEnum;
        this.color = color;
    }

    public static String getDescByType(byte type) {
        for (TaskEnum taskTypeEnum : TaskEnum.values()) {
            if (taskTypeEnum.getType() != type) continue;
            return taskTypeEnum.getDesc();
        }
        return null;
    }

    public static String[] getTableColumByType(byte type) {
        for (TaskEnum taskTypeEnum : TaskEnum.values()) {
            if (taskTypeEnum.getType() != type) continue;
            return taskTypeEnum.getTableColumn();
        }
        return null;
    }

    public static PushMessageEnum getPushMessageEnumByDesc(String desc) {
        return Stream.of(TaskEnum.values()).filter(taskTypeEnum -> desc.equals(taskTypeEnum.getDesc())).findAny().get().getPushMessageEnum();
    }

    public static PushMessageEnum getPushMessageEnumByType(byte type) {
        return Stream.of(TaskEnum.values()).filter(taskTypeEnum -> type == taskTypeEnum.getType()).findAny().get().getPushMessageEnum();
    }

    public static TaskEnum getTaskByDesc(String desc) {
        return Arrays.asList(TaskEnum.values()).stream().filter(taskEnum -> desc.equals(taskEnum.getDesc())).findFirst().get();
    }

    public static TaskEnum getTaskByType(byte type) {
        return Arrays.stream(TaskEnum.values()).filter(taskEnum -> type == taskEnum.getType()).findFirst().get();
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String[] getTableColumn() {
        return this.tableColumn;
    }

    public void setTableColumn(String[] tableColumn) {
        this.tableColumn = tableColumn;
    }

    public PushMessageEnum getPushMessageEnum() {
        return this.pushMessageEnum;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }
}

