/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyuncs.AcsRequest;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.IAcsClient;
import com.aliyuncs.mts.model.v20140618.SubmitJobsRequest;
import com.aliyuncs.mts.model.v20140618.SubmitJobsResponse;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.bxm.localnews.news.config.OssProperties;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.vo.TranscodeMap;
import com.bxm.newidea.component.redis.KeyGenerator;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import it.sauronsoftware.jave.Encoder;
import it.sauronsoftware.jave.MultimediaInfo;
import it.sauronsoftware.jave.VideoInfo;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class OssTransCodeUtils {
    private static final String MP4_SUFFIX = ".mp4";
    private static final String MP4_FOLDER = "/mp4/";
    private static final String H264 = "h264";
    @Resource
    private OssProperties ossProperties;
    @Resource
    private RedisSetAdapter redisSetAdapter;
    @Resource
    private RedisListAdapter redisListAdapter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transCodeByOriginUrl(String originUrl, Long postId) {
        if (!this.ossProperties.getTranscodeSwitch().booleanValue() || StringUtils.isBlank((CharSequence)originUrl) || !originUrl.contains(this.ossProperties.getUrlPrefix())) {
            return false;
        }
        KeyGenerator videoTranscodeKey = RedisConfig.VIDEO_TRANSCODE.copy().appendKey((Object)postId);
        if (this.redisSetAdapter.exists(videoTranscodeKey, (Object)originUrl).booleanValue()) {
            return true;
        }
        String dealOriginUrl = originUrl.replace(this.ossProperties.getUrlPrefix(), "");
        int index = originUrl.lastIndexOf("/");
        if (index < 0) {
            return false;
        }
        String fileName = originUrl.substring(index + 1);
        boolean downloadResult = this.download(dealOriginUrl, fileName);
        if (!downloadResult) {
            return false;
        }
        File file = new File(fileName);
        try {
            Encoder encoder = new Encoder();
            MultimediaInfo info = encoder.getInfo(file);
            VideoInfo video = info.getVideo();
            String decoder = video.getDecoder();
            if (H264.equals(decoder)) {
                this.redisSetAdapter.add(videoTranscodeKey, new Object[]{originUrl});
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            file.delete();
        }
        index = originUrl.lastIndexOf(".");
        if (index < 0) {
            return false;
        }
        String fileSuffix = originUrl.substring(index + 1);
        String destUrl = dealOriginUrl.replace("/" + fileSuffix + "/", MP4_FOLDER).replace("." + fileSuffix, MP4_SUFFIX);
        boolean result = this.transCode(dealOriginUrl, destUrl);
        if (result) {
            destUrl = this.ossProperties.getUrlPrefix() + destUrl;
            TranscodeMap transcodeMap = new TranscodeMap();
            transcodeMap.setPostId(postId);
            transcodeMap.setOriginUrl(originUrl);
            transcodeMap.setDestUrl(destUrl);
            this.redisListAdapter.leftPush(RedisConfig.VIDEO_TRANSCODE_MAP.copy(), new Object[]{transcodeMap});
            this.redisSetAdapter.add(videoTranscodeKey, new Object[]{destUrl});
            return true;
        }
        return false;
    }

    private boolean transCode(String ossInputObject, String ossOutputObject) {
        String outputObject;
        IAcsClient client = this.getiAcsClient();
        SubmitJobsRequest request = new SubmitJobsRequest();
        JSONObject input = new JSONObject();
        input.put("Location", (Object)this.ossProperties.getOssLocation());
        input.put("Bucket", (Object)this.ossProperties.getOssBucket());
        try {
            input.put("Object", (Object)URLEncoder.encode(ossInputObject, "utf-8"));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        request.setInput(input.toJSONString());
        try {
            outputObject = URLEncoder.encode(ossOutputObject, "utf-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return false;
        }
        JSONObject output = new JSONObject();
        output.put("OutputObject", (Object)outputObject);
        output.put("TemplateId", (Object)this.ossProperties.getTemplateId());
        JSONArray outputs = new JSONArray();
        outputs.add((Object)output);
        request.setOutputs(outputs.toJSONString());
        request.setOutputBucket(this.ossProperties.getOssBucket());
        request.setOutputLocation(this.ossProperties.getOssLocation());
        request.setPipelineId(this.ossProperties.getPipelineId());
        try {
            SubmitJobsResponse response = (SubmitJobsResponse)client.getAcsResponse((AcsRequest)request);
            if (((SubmitJobsResponse.JobResult)response.getJobResultList().get(0)).getSuccess().booleanValue()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private IAcsClient getiAcsClient() {
        DefaultProfile profile = DefaultProfile.getProfile((String)this.ossProperties.getMpsRegionId(), (String)this.ossProperties.getAccessKeyId(), (String)this.ossProperties.getAccessKeySecret());
        return new DefaultAcsClient((IClientProfile)profile);
    }

    private Boolean download(String path, String filePath) {
        try {
            OSSClient ossClient = this.getOssClient();
            GetObjectRequest getObjectRequest = new GetObjectRequest(this.ossProperties.getOssBucket(), path);
            ossClient.getObject(getObjectRequest, new File(filePath));
            ossClient.shutdown();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private OSSClient getOssClient() {
        return new OSSClient(this.ossProperties.getEndpoint(), this.ossProperties.getAccessKeyId(), this.ossProperties.getAccessKeySecret());
    }
}

