package com.bxm.localnews.news.domain;

import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.NewsRecommendParam;
import com.bxm.localnews.news.vo.NewsVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

@Mapper
public interface NewsMapper {

    News selectByPrimaryKey(Long id);

    List<News> recommendNews(NewsRecommendParam param);

    /**
     * 给用户推荐本地新闻
     * @param param 推荐参数
     * @return 本地新闻列表
     */
    List<News> recommendLocalnews(NewsRecommendParam param);

    List<News> firstRecommendNews(NewsRecommendParam param);

    List<News> queryRecommendNewsList(@Param("newsId") Long newsId, @Param("pageSize") int pageSize, @Param("userId") Long userId);

    List<News> queryVideoList(NewsRecommendParam param);

    /**
     * 根据关键字和搜索词检索新闻信息
     * @param word    搜索的词
     * @param keyword 分词后的检索词
     * @param page    分页参数
     * @return 搜索结果
     */
    List<News> searchNews(@Param("keyword") String keyword, @Param("word") String word, @Param("page") MPage page);

    List<News> getTops();

    NewsVO getById(@Param("id") Long id, @Param("userId") Long userId);

    News selectWithoutContentByPrimaryKey(Long id);

}