/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.service.InitTagService;
import com.bxm.localnews.news.service.NewsKindService;
import com.bxm.localnews.news.service.NewsRecommendedService;
import com.bxm.localnews.news.service.NewsReplyService;
import com.bxm.localnews.news.service.UserKindService;
import com.bxm.localnews.news.service.UserTagService;
import com.bxm.localnews.news.service.VideoReplyFacadeService;
import com.bxm.localnews.news.service.WeightService;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.tools.DateUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"4-90 \u7ed9\u7528\u6237\u521d\u59cb\u5316\u65b0\u95fb\u753b\u50cf"}, description="\u9ed8\u8ba4\u7528\u6237\u3001\u65b0\u6ce8\u518c\u7528\u6237\uff0c\u7ed9\u5176\u5bf9\u5e94\u7684\u65b0\u95fb\u753b\u50cf\u3001\u6807\u7b7e")
@RestController
@RequestMapping(value={"facade/news"})
public class UserInitController {
    private NewsKindService newsKindService;
    private InitTagService initTagService;
    private UserTagService userTagService;
    private NewsRecommendedService newsRecommendedService;
    private UserKindService userKindService;
    private NewsReplyService newsReplyService;
    private VideoReplyFacadeService videoReplyFacadeService;
    private WeightService weightService;

    @Autowired
    public UserInitController(NewsKindService newsKindService, InitTagService initTagService, UserTagService userTagService, NewsRecommendedService newsRecommendedService, UserKindService userKindService, WeightService weightService) {
        this.newsKindService = newsKindService;
        this.initTagService = initTagService;
        this.userTagService = userTagService;
        this.newsRecommendedService = newsRecommendedService;
        this.userKindService = userKindService;
        this.weightService = weightService;
    }

    @ApiOperation(value="4-90-1 \u521d\u59cb\u5316\u7528\u6237", notes="\u4e3a\u6307\u5b9a\u7684\u7528\u6237\u63a8\u8350\u4e00\u5b9a\u91cf\u7684\u89c6\u9891\u6570\u91cf,\u5982\u679c\u8fd4\u56de\u7684\u7ed3\u679c\u6570\u7ec4\u957f\u5ea6\u4e3a0\uff0c\u8868\u793a\u6ca1\u6709\u66f4\u591a\u7684\u89c6\u9891\u53ef\u4ee5\u63a8\u8350")
    @ApiImplicitParams(value={@ApiImplicitParam(name="newUserId", value="\u65b0\u6ce8\u518c\u7528\u6237ID"), @ApiImplicitParam(name="defaultUserId", value="\u9759\u9ed8\u7528\u6237ID")})
    @PostMapping(value={"init"})
    public void initUser(@RequestParam Long newUserId, @RequestParam(required=false) Long defaultUserId) {
        Date copyStartDate = DateUtils.addField((Date)new Date(), (int)5, (int)-1);
        if (null == defaultUserId) {
            this.newsKindService.createUserDefaultKinds(newUserId);
            this.initTagService.createInitTags(newUserId);
        } else {
            this.userTagService.doCopyTags(defaultUserId, newUserId, copyStartDate);
            this.newsRecommendedService.copyRecommendeds(defaultUserId, newUserId, copyStartDate);
            this.userKindService.copyKinds(defaultUserId, newUserId);
        }
    }

    @ApiOperation(value="4-90-2 \u540c\u6b65\u7528\u6237\u4fe1\u606f", notes="\u7528\u6237\u4fe1\u606f\u53d8\u66f4\u540e\uff0c\u540c\u6b65\u5197\u4f59\u7528\u6237\u5b57\u6bb5")
    @PostMapping(value={"sync"})
    public void syncUser(@RequestBody UserBean user) {
    }

    @PostMapping(value={"/recalcu"})
    public Json add(Long userId) {
        this.weightService.recalcuUserTagWeight(userId);
        return ResultUtil.genSuccessResult();
    }
}

