/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.facade.NewsSyncFeignService;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.MarketingActivitiesMapper;
import com.bxm.localnews.news.domain.NewsMapper;
import com.bxm.localnews.news.domain.NewsMonitorMapper;
import com.bxm.localnews.news.domain.UserKindMapper;
import com.bxm.localnews.news.service.NewsQuartzService;
import com.bxm.localnews.news.vo.MarketingActivities;
import com.bxm.localnews.news.vo.MonitorTaskBuildParam;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.NewsKind;
import com.bxm.localnews.news.vo.UserKind;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisListAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NewsQuartzServiceImpl
extends BaseService
implements NewsQuartzService {
    @Autowired
    NewsMonitorMapper newsMonitorMapper;
    @Autowired
    NewsMapper newsMapper;
    @Autowired
    RedisSetAdapter redisSetAdapter;
    @Autowired
    RedisHashMapAdapter redisHashMapAdapter;
    @Autowired
    RedisListAdapter redisListAdapter;
    @Autowired
    UserKindMapper userKindMapper;
    @Autowired
    MarketingActivitiesMapper marketingActivitiesMapper;
    @Autowired
    NewsSyncFeignService newsSyncFeignService;

    @Override
    public Integer countNews(MonitorTaskBuildParam monitorTaskBuildParam) {
        return this.newsMonitorMapper.count(monitorTaskBuildParam);
    }

    @Override
    public void syncMykindToData() {
        long limit = 5000L;
        List userIds = this.redisSetAdapter.pop(RedisConfig.NEWS_USER_KIND_SET, Long.valueOf(limit), Long.class);
        if (CollectionUtils.isEmpty((Collection)userIds)) {
            return;
        }
        TypeReference<List<NewsKind>> typeReference = new TypeReference<List<NewsKind>>(){};
        userIds.forEach(arg_0 -> this.lambda$syncMykindToData$0((TypeReference)typeReference, arg_0));
        if (this.redisSetAdapter.size(RedisConfig.NEWS_USER_KIND_SET) > 0L) {
            this.syncMykindToData();
        }
    }

    @Override
    public void publishMarketingActivities() {
        List list = this.marketingActivitiesMapper.listForQuartz(Integer.valueOf(0));
        for (MarketingActivities marketingActivities : list) {
            MarketingActivities param = new MarketingActivities();
            param.setId(marketingActivities.getId());
            param.setStatus(Integer.valueOf(1));
            this.marketingActivitiesMapper.update(param);
        }
    }

    @Override
    public void publishNews(Long newsId) {
        News news = this.newsMapper.selectByPrimaryKey(newsId);
        News newsParam = new News();
        newsParam.setId(newsId);
        newsParam.setTop(news.getTop());
        newsParam.setHot(news.getHot());
        newsParam.setKindTop(news.getKindTop());
        newsParam.setKindId(news.getKindId());
        newsParam.setReviewStatus(news.getReviewStatus());
        newsParam.setStatus(Byte.valueOf((byte)1));
        newsParam.setHotExpireTime(news.getHotExpireTime());
        newsParam.setTopExpireTime(news.getTopExpireTime());
        newsParam.setIssueTime(news.getIssueTime());
        newsParam.setPublishTime(news.getPublishTime());
        newsParam.setAreaDetail(news.getAreaDetail());
        this.newsSyncFeignService.save(newsParam);
    }

    @Override
    public void expireHotNews() {
        List list = this.newsMapper.getExpireHotList();
        for (News news : list) {
            News newsParam = new News();
            newsParam.setId(news.getId());
            newsParam.setTop(news.getTop());
            newsParam.setHot(Byte.valueOf((byte)1));
            newsParam.setKindTop(news.getKindTop());
            newsParam.setKindId(news.getKindId());
            newsParam.setReviewStatus(news.getReviewStatus());
            newsParam.setStatus(news.getStatus());
            newsParam.setHotExpireTime(null);
            newsParam.setTopExpireTime(news.getTopExpireTime());
            newsParam.setIssueTime(news.getIssueTime());
            newsParam.setPublishTime(news.getPublishTime());
            newsParam.setAreaDetail(news.getAreaDetail());
            this.newsSyncFeignService.save(newsParam);
        }
    }

    @Override
    public void updateMonitorStatus(Long id, int status, String message) {
        this.newsMonitorMapper.updateMonitorStatus(id, status, message);
    }

    private /* synthetic */ void lambda$syncMykindToData$0(TypeReference typeReference, Long userId) {
        List newsKindList = (List)this.redisHashMapAdapter.get(RedisConfig.NEWS_USER_KIND, userId.toString(), typeReference);
        if (CollectionUtils.isNotEmpty((Collection)newsKindList)) {
            this.userKindMapper.deleteByUserId(userId);
            ArrayList userKindList = Lists.newArrayList();
            int i = 0;
            for (NewsKind newsKind : newsKindList) {
                UserKind userKind = new UserKind();
                userKind.setUserId(userId);
                userKind.setKindId(newsKind.getId());
                userKind.setSortNo(Integer.valueOf(i));
                userKindList.add(userKind);
                ++i;
            }
            this.userKindMapper.batchInsert((List)userKindList);
        }
    }
}

