package com.bxm.localnews.news.controller;

import com.bxm.localnews.news.dto.CalculatePostDTO;
import com.bxm.localnews.news.service.ForumService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Api(tags = "4-93 [内部]帖子静态数据变更", description = "包括推荐、阅读、有效阅读次数...")
@RestController
@RequestMapping("facade/post/statistic")
public class ForumPostStatisticController {

    @Autowired
    private ForumService forumService;

    @ApiOperation(value = "4-93-1 帖子推荐次数消费", notes = "对帖子的推荐次数进行消费")
    @PostMapping("recommended")
    public void postRecommendedConsume(@RequestParam(value = "userId")Long userId,@RequestParam(value = "postIds") List<Long> ids) {
        forumService.doConsumeRecommendedCount(ids,userId);
    }

    @ApiOperation(value = "4-93-2 帖子阅读次数消费", notes = "对帖子的阅读次数进行消费")
    @PostMapping("click")
    public void postClickConsume(@RequestParam(value = "userId")Long userId,@RequestParam(value = "postId") Long postId) {
        forumService.doConsumeClickCount(postId,userId);
    }

    @ApiOperation(value = "4-93-3 帖子有效阅读次数消费", notes = "对帖子的有效阅读次数进行消费")
    @PostMapping("active")
    public void postActiveViewConsume(@RequestParam(value = "userId")Long userId,@RequestParam(value = "postId") Long postId) {
        forumService.doConsumeActiveViewCount(postId,userId);
    }


    @ApiOperation(value = "4-93-4 更新点赞表中未展示的数据", notes = "帖子点赞信息同步")
    @PostMapping("refreshLikeInfo")
    public void refreshLikeInfo() {
        forumService.doRefreshLikeInfo();
    }


    @ApiOperation(value = "4-93-4 帖子点赞信息用户昵称,用户头像同步", notes = "帖子点赞信息同步")
    @PostMapping("syncPostLikeInfo")
    public void syncPostLikeInfo() {
        forumService.doSyncPostLikeInfo();
    }

    @ApiOperation(value = "4-93-5 帖子点赞概览,评论概览信息同步", notes = "点赞概览,评论概览信息同步")
    @PostMapping("syncPostStaticInfo")
    public void syncPostStaticInfo() {
        forumService.doSyncPostStaticInfo();
    }

    @ApiOperation(value = "4-93-6 统计帖子半小时数量", notes = "点赞概览,评论概览信息同步")
    @PostMapping("calculatePostCount")
    public CalculatePostDTO calculatePostCount() {
        return forumService.calculatePostCount();
    }

}
