package com.bxm.localnews.news.controller;

import com.bxm.localnews.news.param.VideoBlackParam;
import com.bxm.localnews.news.param.VideoShareParam;
import com.bxm.localnews.news.param.VideoViewParam;
import com.bxm.localnews.news.service.VideoStatisticService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "4-92 [内部]小视频静态数据变更", description = "包括屏蔽、分享、浏览、评论")
@RestController
@RequestMapping("facade/video/statistic")
public class VideoStatisticController {

    @Autowired
    VideoStatisticService videoStatisticService;

    @ApiOperation(value = "4-92-1 小视频屏蔽消费", notes = "")
    @PostMapping("black")
    public void videoBlackConsume(@RequestBody  VideoBlackParam videoBlackParam) {
        videoStatisticService.videoBlackConsume(videoBlackParam);
    }

    @ApiOperation(value = "4-92-2 小视频分享消费", notes = "")
    @PostMapping("share")
    public void videoShareConsume(@RequestBody VideoShareParam videoShareParam) {
        videoStatisticService.videoShareConsume(videoShareParam);
    }

    @ApiOperation(value = "4-92-3 小视频浏览消费", notes = "")
    @PostMapping("view")
    public void videoViewConsume(@RequestBody VideoViewParam videoViewParam) {
        videoStatisticService.videoViewConsume(videoViewParam);
    }

    @ApiOperation(value = "4-92-4 小视频评论消费", notes = "")
    @PostMapping("comment")
    public void videoCommentConsume(@RequestParam("userId") Long userId,
                                    @RequestParam(value = "newsId")Long newsId) {
        videoStatisticService.videoCommentsConsume(userId,newsId);
    }


}
