package com.bxm.localnews.news.service;

import com.bxm.localnews.news.vo.MonitorTaskBuildParam;

public interface NewsQuartzService {

    /**
     * 用途：查询某两个时间区间的新闻数量
     *
     * @param monitorTaskBuildParam
     * @return
     */
    Integer countNews(MonitorTaskBuildParam monitorTaskBuildParam);

    /**
     * 用途：同步用户标签到redis
     */
    void syncMykindToData();

    /**
     * 用途：定时发布活动
     */
    void publishMarketingActivities();

    /**
     * 用途：定时发布新闻
     *
     * @param newsId
     */
    void publishNews(Long newsId);

    /**
     * 用途：检查过期热门新闻，从推荐表中移除
     */
    void expireHotNews();

    /**
     * 用途：更新新闻监控的状态
     * @param id
     * @param status
     * @param message
     */
    void updateMonitorStatus(Long id, int status, String message);

    /**
     * 用途：扫描评论，并修改评论的展示状态
     */
    void scanningNewsReply();

    /**
     * 用途：想不出叫啥好
     */
    void cleanUserTopPost();

}
