package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.facade.NewsSyncFeignService;
import com.bxm.localnews.integration.MessageIntegrationService;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.*;
import com.bxm.localnews.news.service.NewsQuartzService;
import com.bxm.localnews.news.vo.*;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

@Service
public class NewsQuartzServiceImpl extends BaseService implements NewsQuartzService {

    @Autowired
    private NewsMonitorMapper newsMonitorMapper;

    @Autowired
    private NewsMapper newsMapper;

    @Autowired
    private RedisSetAdapter redisSetAdapter;

    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    private UserKindMapper userKindMapper;

    @Autowired
    private  MarketingActivitiesMapper marketingActivitiesMapper;

    @Autowired
    private NewsSyncFeignService newsSyncFeignService;

    @Autowired
    private NewsReplyMapper newsReplyMapper;

    @Autowired
    private UserReplyMapper userReplyMapper;

    @Autowired
    private NewsTotalMapper newsTotalMapper;

    @Autowired
    private ForumPostMapper forumPostMapper;

    @Autowired
    private MessageIntegrationService messageIntegrationService;

    @Override
    public Integer countNews(MonitorTaskBuildParam monitorTaskBuildParam) {
        return newsMonitorMapper.count(monitorTaskBuildParam);
    }

    @Override
    public void syncMykindToData() {
        long limit = 5000L;
        List<Long> userIds = redisSetAdapter.pop(RedisConfig.NEWS_USER_KIND_SET, limit, Long.class);
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        TypeReference<List<NewsKind>> typeReference = new TypeReference<List<NewsKind>>() {
        };
        userIds.forEach(userId -> {
            List<NewsKind> newsKindList = redisHashMapAdapter.get(RedisConfig.NEWS_USER_KIND, userId.toString(), typeReference);
            if (CollectionUtils.isNotEmpty(newsKindList)) {
                this.userKindMapper.deleteByUserId(userId);

                List<UserKind> userKindList = Lists.newArrayList();
                int i = 0;
                for (NewsKind newsKind : newsKindList) {
                    UserKind userKind = new UserKind();
                    userKind.setUserKindId(nextSequence());
                    userKind.setUserId(userId);
                    userKind.setKindId(newsKind.getId());
                    userKind.setSortNo(i);
                    userKindList.add(userKind);
                    i++;
                }
                MybatisBatchBuilder.create(UserKindMapper.class, userKindList).run(UserKindMapper::insertSelective);
            }
        });

        if (redisSetAdapter.size(RedisConfig.NEWS_USER_KIND_SET) > 0) {
            syncMykindToData();
        }
    }

    @Override
    public void publishMarketingActivities() {
        List<MarketingActivities> list = marketingActivitiesMapper.listForQuartz(0);
        MarketingActivities param;
        for (MarketingActivities marketingActivities : list) {
            param = new MarketingActivities();
            param.setId(marketingActivities.getId());
            param.setStatus(1);
            marketingActivitiesMapper.update(param);
        }
    }

    @Override
    public void publishNews(Long newsId) {
        News news = newsMapper.selectByPrimaryKey(newsId);
        News newsParam = new News();
        newsParam.setId(newsId);
        newsParam.setTop(news.getTop());
        newsParam.setImgUrl(news.getImgUrl());
        newsParam.setHot(news.getHot());
        newsParam.setKindTop(news.getKindTop());
        newsParam.setKindId(news.getKindId());
        newsParam.setReviewStatus(news.getReviewStatus());
        newsParam.setStatus((byte) 1);
        newsParam.setHotExpireTime(news.getHotExpireTime());
        newsParam.setTopExpireTime(news.getTopExpireTime());
        newsParam.setIssueTime(news.getIssueTime());
        newsParam.setPublishTime(news.getPublishTime());
        newsParam.setAreaDetail(news.getAreaDetail());
        newsSyncFeignService.save(newsParam);
    }

    @Override
    public void expireHotNews() {
        List<News> list = newsMapper.getExpireHotList();
        for (News news : list) {
            News newsParam = new News();
            newsParam.setId(news.getId());
            newsParam.setTop(news.getTop());
            newsParam.setImgUrl(news.getImgUrl());
            newsParam.setHot((byte) 1);
            newsParam.setKindTop(news.getKindTop());
            newsParam.setKindId(news.getKindId());
            newsParam.setReviewStatus(news.getReviewStatus());
            newsParam.setStatus(news.getStatus());
            newsParam.setHotExpireTime(null);
            newsParam.setTopExpireTime(news.getTopExpireTime());
            newsParam.setIssueTime(news.getIssueTime());
            newsParam.setPublishTime(news.getPublishTime());
            newsParam.setAreaDetail(news.getAreaDetail());
            newsSyncFeignService.save(newsParam);
        }
    }

    @Override
    public void updateMonitorStatus(Long id, int status, String message) {
        newsMonitorMapper.updateMonitorStatus(id,status,message);
    }

    @Override
    public void scanningNewsReply() {
        //查询已经到达显示时间、并且状态为未展示的的评论
        Date currentTime = new Date();
        List<Long> postIds = newsReplyMapper.selectPostIdByTime(currentTime);
        List<NewsReply>  newsReplyList = newsReplyMapper.selectByTime(currentTime);
        for (NewsReply newsReply:newsReplyList) {
            newsReplyMapper.updateStatus(newsReply.getNewsId(),newsReply.getId());
            userReplyMapper.updateStatus(newsReply.getUserId(),newsReply.getId());
            if (newsReply.getType()==3) {
                ForumPostStatistic forumPostStatistic = ForumPostStatistic.buildComments(newsReply.getNewsId(), 1);
                forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
                messageIntegrationService.pushPostRepkyMessage(newsReply);
            } else if (newsReply.getType()==1) {
                newsTotalMapper.updateNewsTotalComments(newsReply.getNewsId(),1);
            }
        }
        //更新帖子表静态数据
        postIds.stream().forEach(e->{
            ForumPostStatistic forumPostStatistic = ForumPostStatistic.buildComments(e, null);
            List<NewsReply> replyList = newsReplyMapper.selectPostReplyByNewsIdOrderByAddTime(e);
            if (CollectionUtils.isNotEmpty(replyList)){
                forumPostStatistic.setReplyInfo(JSONObject.toJSONString(replyList));
            }
            forumPostMapper.updateStatisticByPrimaryKeySelective(forumPostStatistic);
        });
    }




    @Override
    public void cleanUserTopPost() {

    }
}



