package com.bxm.localnews.news.controller;

import com.bxm.localnews.news.service.ForumService;
import com.bxm.localnews.news.vo.ForumBasicVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "4-95 [内部]帖子接口")
@RestController
@RequestMapping("facade/forumPost")
public class ForumPostController {

    @Autowired
    private ForumService forumService;

    @ApiOperation(value = "4-95-1 生成帖子")
    @PostMapping("createPost")
    public Boolean createPost(@RequestBody ForumBasicVo forumBasicVo) {
        return forumService.createPost(forumBasicVo);
    }

    @ApiOperation(value = "4-95-2 获得用户发帖数量")
    @PostMapping("getPublishPostNum")
    public Integer createPost(@RequestParam("userId") Long userId) {
        return forumService.getPublishPostNum(userId);
    }



}
