package com.bxm.localnews.news.controller;


import com.bxm.localnews.news.service.ForumService;
import com.bxm.localnews.news.service.NewNewsReplyService;
import com.bxm.localnews.news.service.NewsQuartzService;
import com.bxm.localnews.news.vo.MonitorTaskBuildParam;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;

@Api(tags = "4-91 [内部]为定时任务提供调用", description = "为定时任务提供调用")
@RestController
@RequestMapping("facade/news")
public class NewsQuartzController {

    @Autowired
    private NewsQuartzService newsQuartzService;

    @Autowired
    private ForumService forumService;

    @Autowired
    private NewNewsReplyService newNewsReplyService;

    @ApiOperation(value = "4-91-1 [定时任务]调用新闻监测新闻在某个时间区间的数量", notes = "如果数量不够则需要报警告知")
    @PostMapping("quartz/news/monitor")
    public ResponseEntity<Integer> countNews(@RequestBody MonitorTaskBuildParam monitorTaskBuildParam) {
        return ResponseEntity.ok(newsQuartzService.countNews(monitorTaskBuildParam));
    }

    @ApiOperation(value = "4-91-2 [用户]用户频道同步", notes = "用户在初始化频道时，首先会载入至redis缓存中，然后再从缓存中同步至数据库做持久化")
    @PostMapping("quartz/myKind/sync")
    public void syncMykindToData() {
        newsQuartzService.syncMykindToData();
    }

    @ApiOperation(value = "4-91-4 [管理后台]发布新闻", notes = "运营后台管理发布定时新闻时需要调用")
    @PostMapping("quartz/new/publish")
    public void publishNews(@RequestParam("newsId") Long newsId) {
        newsQuartzService.publishNews(newsId);
    }

    @ApiOperation(value = "4-91-5 [管理后台]清理过期热门新闻", notes = "热门有过期时间，一旦到达过期时间需要将新闻从热门新闻推荐池中去除[已取消热门有效期]")
    @PostMapping("quartz/hotNews/expire")
    @Deprecated
    public void checkHotNewsExpire() {
        newsQuartzService.expireHotNews();
    }

    @ApiOperation(value = "4-91-6 [管理后台]更新新闻监控的状态", notes = "")
    @PostMapping("quartz/monitorStatus/update")
    public void updateMonitorStatus(@RequestParam("id") Long id,
                                    @RequestParam("status") int status,
                                    @RequestParam("message") String message) {
        newsQuartzService.updateMonitorStatus(id, status, message);
    }

    @ApiOperation(value = "4-91-6 [管理后台]更新新闻评论的状态", notes = "运营管理后台在添加评论时，会添加未来时间的评论且状态为待展示，需要定时去将未来时间的评论置为[已展示]")
    @PostMapping("/reply/quartz/scanning")
    public void updateNewsReplyStatus() {
        newsQuartzService.scanningNewsReply();
    }

    @ApiOperation(value = "4-91-7 [定时任务]参与人数计算", notes = "参与人数计算")
    @PostMapping("quartz/calcParticipantsNum")
    public void calcParticipantsNum() {
        forumService.calcParticipantsNum();
    }

    @ApiOperation(value = "4-91-8 帖子阅读次数增加", notes = "帖子阅读次数增加")
    @PostMapping("quartz/addPostClick")
    public void addPostClick(@RequestParam(value = "postId") Long postId, @RequestParam(value = "clickCount") Long clickCount) {
        forumService.doSavePostClick(postId, clickCount);
    }

    @ApiOperation(value = "4-91-9 管理后台删除评论", notes = "参与人数计算")
    @PostMapping("/delReply")
    public void delReply(@RequestParam(value = "replyId") Long replyId,
                         @RequestParam(value = "userId")Long userId,
                         @RequestParam(value = "newsId")Long  newsId) {
        newNewsReplyService.delMyReply(replyId,userId,newsId);
    }

}
