package com.bxm.localnews.news.controller;

import java.util.Calendar;
import java.util.Date;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.service.*;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.newidea.component.tools.DateUtils;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@Api(tags = "4-90 [内部]用户新闻画像初始化", description = "默认用户、新注册用户，给其对应的新闻画像、标签")
@RestController
@RequestMapping("facade/news")
public class UserInitController {

    private NewsKindService newsKindService;

    private InitTagService initTagService;

    private UserTagService userTagService;

    private NewsRecommendedService newsRecommendedService;

    private UserKindService userKindService;

    private NewNewsReplyService newsReplyService;

    private WeightService weightService;

    private ForumService forumService;

    private NewsService newsService;

    @Autowired
    public UserInitController(NewsKindService newsKindService,
                              InitTagService initTagService,
                              UserTagService userTagService,
                              NewsRecommendedService newsRecommendedService,
                              UserKindService userKindService,
                              NewNewsReplyService newsReplyService,
                              WeightService weightService,
                              ForumService forumService,
                              NewsService newsService) {
        this.newsKindService = newsKindService;
        this.initTagService = initTagService;
        this.userTagService = userTagService;
        this.newsRecommendedService = newsRecommendedService;
        this.userKindService = userKindService;
        this.weightService = weightService;
        this.newsReplyService = newsReplyService;
        this.forumService = forumService;
        this.newsService = newsService;
    }

    @ApiOperation(value = "4-90-1 [用户]初始化用户", notes = "初始化用户的频道和标签")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "newUserId", value = "新注册用户ID"),
            @ApiImplicitParam(name = "defaultUserId", value = "静默用户ID")
    })
    @PostMapping("init")
    public void initUser(@RequestParam Long newUserId, @RequestParam(required = false) Long defaultUserId) {
        Date copyStartDate = DateUtils.addField(new Date(), Calendar.DATE, -1);

        if (null == defaultUserId) {
            this.newsKindService.createUserDefaultKinds(newUserId);
            this.initTagService.createInitTags(newUserId);
        } else {
            this.userTagService.doCopyTags(defaultUserId, newUserId, copyStartDate);
            this.newsRecommendedService.copyRecommendeds(defaultUserId, newUserId, copyStartDate);
            this.userKindService.copyKinds(defaultUserId, newUserId);
        }
    }

    @ApiOperation(value = "4-90-2 [用户]同步用户信息", notes = "用户信息变更后，同步冗余用户字段")
    @PostMapping("sync")
    public void syncUser(@RequestBody UserBean user) {
        this.newsReplyService.doTriggerUpdateInfo(user.getId(), user.getNickname(), user.getHeadImg());
        this.forumService.triggerUpdateInfo(user.getId(), user.getNickname(), user.getHeadImg());
        this.forumService.doTriggerUpdateForumPostLikeInfo(user.getId(), user.getNickname(), user.getHeadImg());
        this.newsService.doTriggerUpdateNewsLikeInfo(user.getId(), user.getNickname(), user.getHeadImg());
    }

    @ApiOperation(value = "4-90-3 [推荐]重新计算用户标签", notes = "在数据的逐步推荐中，进行标签的热更新")
    @PostMapping("/recalcu")
    public Json add(Long userId) {
        this.weightService.recalcuUserTagWeight(userId);
        return ResultUtil.genSuccessResult();
    }
}
