package com.bxm.localnews.news.service.impl;

import java.util.Objects;

import com.bxm.localnews.integration.MessageIntegrationService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.MixedRecommendPoolMapper;
import com.bxm.localnews.news.factory.impl.ExtendFactory;
import com.bxm.localnews.news.param.OptimizationNoticeParam;
import com.bxm.localnews.news.service.ForumService;
import com.bxm.localnews.news.service.MixRecommandQuarzService;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.MixedRecommendPool;
import com.bxm.localnews.param.AccountGoldParam;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MixRecommandQuarzServiceImpl implements MixRecommandQuarzService {
    private final ForumPostMapper forumPostMapper;

    private final MessageIntegrationService messageIntegrationService;

    private final UserAccountIntegrationService userAccountIntegrationService;

    private final MixedRecommendPoolMapper mixedRecommendPoolMapper;

    private final ForumService forumService;


    @Autowired
    public MixRecommandQuarzServiceImpl(ForumPostMapper forumPostMapper,
                                        MessageIntegrationService messageIntegrationService,
                                        UserAccountIntegrationService userAccountIntegrationService,
                                        MixedRecommendPoolMapper mixedRecommendPoolMapper,
                                        ForumService forumService) {
        this.forumPostMapper = forumPostMapper;
        this.messageIntegrationService = messageIntegrationService;
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
        this.forumService = forumService;
    }


    @Override
    public Boolean doSendOptimizationNotice(OptimizationNoticeParam optimizationNoticeParam) {
        ForumPostVo forumPostVo = forumPostMapper.selectByPrimaryKey(optimizationNoticeParam.getId());
        Long userId = forumPostVo.getUserId();
        //帖子加入推荐库奖励60多小红花
        String content = "你发布的【" + ExtendFactory.getPostContent(forumPostVo.getTitle(), forumPostVo.getTextField()) + "】被选为优质头条";
        Boolean addGold = userAccountIntegrationService.addGold(AccountGoldParam.buildAddRecommandPoolParam(userId, 60, forumPostVo.getId(), content));
        if (addGold) {
            //发送推送
            MixedRecommendPool recommendPool = mixedRecommendPoolMapper.selectByPrimaryKey(optimizationNoticeParam.getId());
            forumService.judgeEnablePlaceholder(forumPostVo,null);
            forumService.exchangeDetailPost(forumPostVo);
            messageIntegrationService.pushPostAddRecommendPool(forumPostVo, recommendPool);
            //更新数据库 是否优化通知 字段
            if (Objects.nonNull(recommendPool.getOptimizationNotice()) && recommendPool.getOptimizationNotice() == 1) {
                recommendPool.setOptimizationNotice((byte) 2);
                mixedRecommendPoolMapper.updateByPrimaryKeySelective(recommendPool);
            }

        }
        return addGold;
    }
}
