package com.bxm.localnews.news.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.bxm.component.mybatis.utils.MybatisBatchBuilder;
import com.bxm.localnews.facade.NewsSyncFeignService;
import com.bxm.localnews.integration.MessageIntegrationService;
import com.bxm.localnews.integration.NewsSearchIntegrationService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.news.constant.RedisConfig;
import com.bxm.localnews.news.domain.*;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.service.ForumService;
import com.bxm.localnews.news.service.NewNewsReplyService;
import com.bxm.localnews.news.service.NewsQuartzService;
import com.bxm.localnews.news.service.NewsService;
import com.bxm.localnews.news.vo.*;
import com.bxm.newidea.component.redis.RedisHashMapAdapter;
import com.bxm.newidea.component.redis.RedisSetAdapter;
import com.bxm.newidea.component.service.BaseService;
import com.bxm.newidea.component.tools.DateUtils;
import com.bxm.newidea.component.tools.SpringContextHolder;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.stereotype.Service;

import java.util.*;

import static java.util.stream.Collectors.groupingBy;

@Service
public class NewsQuartzServiceImpl extends BaseService implements NewsQuartzService {

    @Autowired
    private NewsMonitorMapper newsMonitorMapper;

    @Autowired
    private NewsMapper newsMapper;

    @Autowired
    private RedisSetAdapter redisSetAdapter;

    @Autowired
    private RedisHashMapAdapter redisHashMapAdapter;

    @Autowired
    private UserKindMapper userKindMapper;

    @Autowired
    private NewsSyncFeignService newsSyncFeignService;

    @Autowired
    private NewsReplyMapper newsReplyMapper;

    @Autowired
    private UserReplyMapper userReplyMapper;

    @Autowired
    private ForumPostMapper forumPostMapper;

    @Autowired
    private MessageIntegrationService messageIntegrationService;

    @Autowired
    private UserIntegrationService userIntegrationService;

    @Autowired
    private ForumService forumService;

    @Autowired
    private NewsSearchIntegrationService newsSearchIntegrationService;

    @Autowired
    private NewsService newsService;

    @Override
    public Integer countNews(MonitorTaskBuildParam monitorTaskBuildParam) {
        return newsMonitorMapper.count(monitorTaskBuildParam);
    }

    @Override
    public void syncMykindToData() {
        long limit = 5000L;
        List<Long> userIds = redisSetAdapter.pop(RedisConfig.NEWS_USER_KIND_SET, limit, Long.class);
        if (CollectionUtils.isEmpty(userIds)) {
            return;
        }
        TypeReference<List<NewsKind>> typeReference = new TypeReference<List<NewsKind>>() {
        };
        userIds.forEach(userId -> {
            List<NewsKind> newsKindList = redisHashMapAdapter.get(RedisConfig.NEWS_USER_KIND, userId.toString(), typeReference);
            if (CollectionUtils.isNotEmpty(newsKindList)) {
                this.userKindMapper.deleteByUserId(userId);

                List<UserKind> userKindList = Lists.newArrayList();
                int i = 0;
                for (NewsKind newsKind : newsKindList) {
                    UserKind userKind = new UserKind();
                    userKind.setUserKindId(nextSequence());
                    userKind.setUserId(userId);
                    userKind.setKindId(newsKind.getId());
                    userKind.setSortNo(i);
                    userKindList.add(userKind);
                    i++;
                }
                MybatisBatchBuilder.create(UserKindMapper.class, userKindList).run(UserKindMapper::insertSelective);
            }
        });

        if (redisSetAdapter.size(RedisConfig.NEWS_USER_KIND_SET) > 0) {
            syncMykindToData();
        }
    }

    @Override
    public void publishNews(Long newsId) {
        News newsParam = new News();
        newsParam.setId(newsId);
        newsParam.setStatus((byte) 1);
        newsSyncFeignService.updateStatus(newsParam);
    }

    @Override
    public void expireHotNews() {
        List<News> list = newsMapper.getExpireHotList();
        for (News news : list) {
            News newsParam = new News();
            newsParam.setId(news.getId());
            newsParam.setHot((byte) 1);
            newsSyncFeignService.updateStatus(newsParam);
        }
    }

    @Override
    public void updateMonitorStatus(Long id, int status, String message) {
        newsMonitorMapper.updateMonitorStatus(id, status, message);
    }

    @Override
    public void scanningNewsReply() {
        //查询已经到达显示时间、并且状态为未展示的的评论
        List<NewsReply> newsReplyList = newsReplyMapper.selectByTime();
        for (NewsReply newsReply : newsReplyList) {
            newsReplyMapper.updateStatus(newsReply.getNewsId(), newsReply.getId());
            userReplyMapper.updateStatus(newsReply.getUserId(), newsReply.getId());
            //维护静态数据及发送推送
            this.pushAndStatic(newsReply);
            logger.info("评论数据:[{}],推送时间:[{}]",JSONObject.toJSONString(newsReply), DateFormatUtils.format(new Date(), DateUtils.DATE_TIME_FORMAT));
        }
        //分组查找需要维护静态数据的帖子,新闻
        Collection<List<NewsReply>> values = newsReplyList.stream().collect(groupingBy(NewsReply::getNewsId)).values();
        values.stream().forEach(e->{
            Optional<NewsReply> first = e.stream().findFirst();
            if (first.isPresent()){
                //维护静态静态数据
                SpringContextHolder.getBean(NewNewsReplyService.class).updateComment(first.get());
            }
        });
    }


    /**
     * 维护静态数据及发送推送
     * @param newsReply
     */
    private void pushAndStatic(NewsReply newsReply){
        //该评论为回复时,给上级评论人推送
        if (newsReply.getParentId() != 0 && newsReply.getRootId() != 0) {
            //维护根评论互动值
            NewsReply rootReply = newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReply.getRootId(), newsReply.getNewsId());
            Integer interactiveCount = rootReply.getInteractiveCount();
            interactiveCount = (Objects.isNull(interactiveCount) || interactiveCount == 0) ? 3 : interactiveCount + 3;
            rootReply.setInteractiveCount(interactiveCount);
            newsReplyMapper.updateByPrimaryKeySelective(rootReply);
            //根评论状态为删除时,将该评论的状态也置为删除,同时不发送推送
            if (rootReply.getDeleteFlag() ==  0) {
                //用户信息不为空,且上级评论的用户状态可用时放推送
                UserBean userBean = userIntegrationService.selectUserFromCache(newsReply.getParentUserId());
                boolean userAvailable = Objects.nonNull(userBean) && Objects.nonNull(userBean.getState()) && userBean.getState() == 1;
                if (userAvailable) {
                    if (newsReply.getType() == ReplyTypeEnum.POST_REPLY.getCode()) {
                        ForumPostVo forumPostVo = forumPostMapper.selectByPrimaryKey(newsReply.getNewsId());
                        if (null != forumPostVo && forumPostVo.getStatus() != 4) {
                            try {
                                forumService.judgeEnablePlaceholder(forumPostVo,null);
                                forumPostVo.setPostImgList(forumService.getDetailFromPost(forumPostVo.getPostImgList()));
                            } catch (Exception e) {
                                logger.error("[评论定时扫描]扫描评论表组装推送消息时报错:[{}],数据:[{}]",e.getMessage(), JSONObject.toJSONString(forumPostVo));
                            }
                            messageIntegrationService.pushNewReplyMessage(newsReply, PushMessageEnum.POST_REPLY,forumPostVo,null);
                        }
                    } else if (newsReply.getType() == ReplyTypeEnum.NEWS_REPLY.getCode()) {
                        News news = newsSearchIntegrationService.multipleGet(new Long[]{newsReply.getNewsId()}).get(0);
                        if (null !=news) {
                            newsService.judgeEnablePlaceholder(news,null);
                            newsService.exchangeDetailNews(news);
                            messageIntegrationService.pushNewReplyMessage(newsReply, PushMessageEnum.NEWS_REPLY,null,news);
                        }
                    }
                }
            }else{
                rootReply.setDeleteFlag((byte) 2);
                newsReplyMapper.updateByPrimaryKeySelective(rootReply);
            }
        }
        //维护帖子,新闻静态数据,且发送推送
        if (newsReply.getType() == ReplyTypeEnum.POST_REPLY.getCode()) {
            if (newsReply.getRootId() == 0 ) {
                ForumPostVo forumPostVo = forumPostMapper.selectByPrimaryKey(newsReply.getNewsId());
                if (Objects.nonNull(forumPostVo) && forumPostVo.getStatus() != 4){
                    forumService.exchangeDetailPost(forumPostVo);
                    messageIntegrationService.pushPostReplyMessage(newsReply,forumPostVo);
                }
            }
        }
    }


    @Override
    public void cleanUserTopPost() {

    }
}



