/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.service.impl;

import com.bxm.localnews.integration.MessageIntegrationService;
import com.bxm.localnews.integration.UserAccountIntegrationService;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.MixedRecommendPoolMapper;
import com.bxm.localnews.news.factory.impl.ExtendFactory;
import com.bxm.localnews.news.param.OptimizationNoticeParam;
import com.bxm.localnews.news.service.ForumService;
import com.bxm.localnews.news.service.MixRecommandQuarzService;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.MixedRecommendPool;
import com.bxm.localnews.param.AccountGoldParam;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MixRecommandQuarzServiceImpl
implements MixRecommandQuarzService {
    private final ForumPostMapper forumPostMapper;
    private final MessageIntegrationService messageIntegrationService;
    private final UserAccountIntegrationService userAccountIntegrationService;
    private final MixedRecommendPoolMapper mixedRecommendPoolMapper;
    private final ForumService forumService;

    @Autowired
    public MixRecommandQuarzServiceImpl(ForumPostMapper forumPostMapper, MessageIntegrationService messageIntegrationService, UserAccountIntegrationService userAccountIntegrationService, MixedRecommendPoolMapper mixedRecommendPoolMapper, ForumService forumService) {
        this.forumPostMapper = forumPostMapper;
        this.messageIntegrationService = messageIntegrationService;
        this.userAccountIntegrationService = userAccountIntegrationService;
        this.mixedRecommendPoolMapper = mixedRecommendPoolMapper;
        this.forumService = forumService;
    }

    @Override
    public Boolean doSendOptimizationNotice(OptimizationNoticeParam optimizationNoticeParam) {
        ForumPostVo forumPostVo = this.forumPostMapper.selectByPrimaryKey(optimizationNoticeParam.getId());
        Long userId = forumPostVo.getUserId();
        String content = "\u4f60\u53d1\u5e03\u7684\u3010" + ExtendFactory.getPostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()) + "\u3011\u88ab\u9009\u4e3a\u4f18\u8d28\u5934\u6761";
        Boolean addGold = this.userAccountIntegrationService.addGold(AccountGoldParam.buildAddRecommandPoolParam((Long)userId, (int)60, (Long)forumPostVo.getId(), (String)content));
        if (addGold.booleanValue()) {
            MixedRecommendPool recommendPool = this.mixedRecommendPoolMapper.selectByPrimaryKey(optimizationNoticeParam.getId());
            this.forumService.judgeEnablePlaceholder(forumPostVo, null);
            this.forumService.exchangeDetailPost(forumPostVo);
            this.messageIntegrationService.pushPostAddRecommendPool(forumPostVo, recommendPool);
            if (Objects.nonNull(recommendPool.getOptimizationNotice()) && recommendPool.getOptimizationNotice() == 1) {
                recommendPool.setOptimizationNotice(Byte.valueOf((byte)2));
                this.mixedRecommendPoolMapper.updateByPrimaryKeySelective(recommendPool);
            }
        }
        return addGold;
    }
}

