package com.bxm.localnews.news.service;

import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.vo.News4Client;
import com.bxm.localnews.news.vo.NewsDetailVO;
import com.bxm.localnews.news.vo.NewsUrlVo;
import com.bxm.newidea.component.vo.Message;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public interface MPUserService {

    void add(Long uid, String mpId, int num);

    /**
     * 获取新闻详情
     * @param articleId
     * @param userId
     * @param type
     * @return
     */
    Json<NewsDetailVO> detail(Long articleId, Long userId, Byte type);

    Object execGetGold(Long articleId, Long userId, Integer viewTime, String tabType, String advertShow);

    /**
     * 阅读文章返回时调用
     * @param articleId
     * @param userId
     * @param viewTime
     * @param tabType
     * @param advertShow
     * @return
     */
    Json getBack(Long articleId, Long userId, Integer viewTime, String tabType, String advertShow);

    Json articleShare(Long articleId, Long userId);

    /**
     * 新闻视频推荐
     * @param articleId
     * @return
     */
    Json<List<News4Client>> articleRecommend(Long articleId);

    /**
     * type=1 推荐订阅号文章   type=2  分享订阅号文章链接
     * @param articleId
     * @param userId
     * @param type
     * @return
     */
    Json<NewsUrlVo> getUrl(Long articleId, Long userId, Byte type);

    /**
     * 点击次数+1
     * @param articleId
     * @return
     */
    Json addClicks(Long articleId);

    /**
     * 复制用户的订阅号
     * @param fromId 来源用户
     * @param toId   目标用户
     * @return 复制结果
     */
    Message copyMPs(Long fromId, Long toId);

}
