package com.bxm.localnews.news.service;

import java.util.List;

import com.bxm.localnews.common.vo.BasicParam;
import com.bxm.localnews.news.dto.KindDTO;
import com.bxm.localnews.news.vo.NewsKind;
import com.bxm.newidea.component.vo.Message;

/**
 * 新闻频道服务接口
 * Created by mars on 2018/3/12.
 */
public interface NewsKindService {

    /**
     * 查询频道
     */
    List<NewsKind> selectAll(BasicParam basicParam);

    /**
     * 创建用户的默认频道
     *
     * @param userId 用户ID，不能为空
     * @return 创建结果
     */
    Message createUserDefaultKinds(Long userId);

    /**
     * 创建用户的默认频道[专为IOS提包准备]
     *
     * @param userId     用户ID，不能为空
     * @param basicParam
     * @return 创建结果
     */
    Message createUserDefaultKindsForPublish(Long userId, BasicParam basicParam);

    /**
     * 获取我的频道
     *
     * @param userId
     * @param basicParam
     * @return
     */
    KindDTO getMyKindAndAllKind(Long userId, BasicParam basicParam);

    /**
     * 添加用户频道
     *
     * @param userId
     * @param kindId
     */
    Message addUserKind(Long userId, Integer kindId);

    /**
     * 对用户频道排序
     *
     * @param userId
     * @param kindIds
     * @param firstOpenType
     */
    void resortUserKind(Long userId, Integer[] kindIds, String firstOpenType);
}
