package com.bxm.localnews.news.service;

import java.util.List;

import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.common.vo.MPage;
import com.bxm.localnews.news.dto.NewsReplyDTO;
import com.bxm.localnews.news.vo.MyReceiveReplysVO;
import com.bxm.localnews.news.vo.MyReplysVO;
import com.bxm.localnews.news.vo.NewsReply;

/**
 * Created by Administrator on 2018/2/23 0023.
 */
public interface NewsReplyService {

    /**
     * 获取回复列表
     *
     * @param newsId
     * @param page
     * @return
     */
    List<NewsReplyDTO> queryReplyList(Long newsId, MPage page);

    /**
     * 用户发表评论
     *
     * @param newsReply
     * @return
     */
    Json reply(NewsReply newsReply);

    /**
     * 获取用户的评论列表
     *
     * @param userId
     * @param page
     * @return
     */
    List<MyReplysVO> selectMyReplys(Long userId, MPage page);

    /**
     * 删除评论
     *
     * @param replyId
     * @return
     */
    Json delMyReply(Long replyId);

    /**
     * 获取收到的评论列表
     *
     * @param userId
     * @param page
     * @return
     */
    List<MyReceiveReplysVO> myReceiveReplys(Long userId, MPage page);

    void triggerUpdateInfo(Long userId, String nickname, String headImg);

}
