package com.bxm.localnews.news.controller;

import com.bxm.localnews.common.util.ResultUtil;
import com.bxm.localnews.common.vo.Json;
import com.bxm.localnews.news.service.WeightService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 用户标签重置对外服务
 */
@RequestMapping("api/public/weight")
@RestController
public class WeightController{

    @Autowired
    private WeightService weightService;

    @PostMapping("/recalcu")
    public Json add(@RequestParam Long userId) {
        this.weightService.recalcuUserTagWeight(userId);
        return ResultUtil.genSuccessResult();
    }


}
