/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.news.controller;

import com.alibaba.fastjson.JSON;
import com.bxm.localnews.news.dto.BaseForumPostDTO;
import com.bxm.localnews.news.dto.ForumPostBriefInfoDto;
import com.bxm.localnews.news.dto.InteractRankInfo;
import com.bxm.localnews.news.service.ForumPostFacadeService;
import com.bxm.localnews.news.service.ForumPostService;
import com.bxm.localnews.news.vo.ForumBasicVo;
import com.bxm.localnews.news.vo.ForumPostClickCountVo;
import com.bxm.localnews.news.vo.ForumPostRankForUserVo;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.ForumRankVo;
import com.bxm.localnews.news.vo.TopicFacadeVO;
import com.bxm.localnews.news.vo.TranscodeMap;
import com.bxm.localnews.news.vo.UserImgVo;
import com.bxm.newidea.component.util.WebUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"4-95 [\u5185\u90e8]\u5e16\u5b50\u63a5\u53e3"})
@RestController
@RequestMapping(value={"facade/forumPost"})
public class ForumPostFacadeController {
    private final ForumPostService forumPostService;
    private final ForumPostFacadeService forumPostFacadeService;

    @Autowired
    public ForumPostFacadeController(ForumPostService forumPostService, ForumPostFacadeService forumPostFacadeService) {
        this.forumPostService = forumPostService;
        this.forumPostFacadeService = forumPostFacadeService;
    }

    @ApiOperation(value="4-95-1 \u751f\u6210\u5e16\u5b50")
    @PostMapping(value={"createPost"})
    public Boolean createPost(@RequestBody ForumBasicVo forumBasicVo) {
        this.forumPostService.doCreateOrUpdatePost(forumBasicVo, null, true);
        return true;
    }

    @ApiOperation(value="4-95-2 \u83b7\u5f97\u7528\u6237\u53d1\u5e16\u6570\u91cf")
    @PostMapping(value={"getPublishPostNum"})
    public Integer createPost(@RequestParam(value="userId") Long userId) {
        return this.forumPostFacadeService.getPublishPostNum(userId);
    }

    @ApiOperation(value="4-95-3 \u6839\u636e\u9605\u8bfb\u6570\u9650\u5236\u83b7\u53d6\u53d1\u5e03\u65f6\u95f4\u5728\u4e00\u5929\u5185\u7684\u5e16\u5b50")
    @PostMapping(value={"getRecentPosts"})
    public List<ForumPostClickCountVo> getRecentPosts(@RequestParam(value="clickCountLimit") Integer clickCountLimit) {
        return this.forumPostFacadeService.getRecentPosts(clickCountLimit);
    }

    @ApiOperation(value="4-95-4 \u6279\u91cf\u589e\u52a0\u5e16\u5b50\u9605\u8bfb\u6570")
    @PostMapping(value={"batchAddClick"})
    public void batchAddClick(@RequestParam(value="forumPostClickListJson") String forumPostClickListJson) {
        this.forumPostFacadeService.batchAddClick(JSON.parseArray((String)forumPostClickListJson, ForumPostClickCountVo.class));
    }

    @ApiOperation(value="4-95-5 \u83b7\u53d6\u5e16\u5b50\u7b80\u7565\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="postId", value="\u5e16\u5b50ID", required=true), @ApiImplicitParam(name="areaCode", value="\u8bbf\u95ee\u8bf7\u6c42\u6765\u6e90\u7528\u6237\u6240\u5c5e\u533a\u57df\u7f16\u7801"), @ApiImplicitParam(name="areaName", value="\u8bbf\u95ee\u8bf7\u6c42\u6765\u6e90\u7528\u6237\u6240\u5c5e\u533a\u57df\u540d\u79f0"), @ApiImplicitParam(name="userId", value="\u8bbf\u95ee\u63a5\u53e3\u7684\u7528\u6237ID")})
    @GetMapping(value={"briefInfo"})
    public ResponseEntity<ForumPostBriefInfoDto> getBriefInfo(@RequestParam(value="postId") Long postId, @RequestParam(value="areaCode", required=false) String areaCode, @RequestParam(value="areaName", required=false) String areaName, @RequestParam(value="userId", required=false) Long userId, HttpServletRequest request) {
        String ip = WebUtils.getIpAddr((HttpServletRequest)request);
        return ResponseEntity.ok((Object)this.forumPostFacadeService.getBriefInfo(postId, userId, areaCode, ip));
    }

    @ApiOperation(value="4-95-6 \u5e16\u5b50\u89c6\u9891\u8f6c\u7801")
    @PostMapping(value={"transcodePostVideo"})
    public void transcodePostVideo(@RequestParam(value="postId") Long postId) {
        this.forumPostFacadeService.transcodePostVideo(postId, null);
    }

    @ApiOperation(value="4-95-7 \u6279\u91cf\u66ff\u6362\u5e16\u5b50\u89c6\u9891\u5730\u5740")
    @PostMapping(value={"batchUpdatePostVideo"})
    public void batchUpdatePostVideo(@RequestParam(value="transcodeMapListJson") String transcodeMapListJson) {
        this.forumPostFacadeService.batchUpdatePostVideo(JSON.parseArray((String)transcodeMapListJson, TranscodeMap.class));
    }

    @ApiOperation(value="4-95-8 \u83b7\u53d6\u7528\u6237\u6700\u8fd1\u4e03\u5929\u5185\u53d1\u7684\u5e16\u5b50")
    @GetMapping(value={"getForumPostByUserId"})
    public ResponseEntity<BaseForumPostDTO> getForumPostByUserId(@RequestParam(value="targetUserId") Long targetUserId, @RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.forumPostFacadeService.getForumPostByUserId(userId, targetUserId));
    }

    @ApiOperation(value="4-95-9 \u6279\u91cf\u83b7\u53d6\u7528\u6237\u5e16\u5b50\u56fe\u7247")
    @GetMapping(value={"batchGetUserImg"})
    public ResponseEntity<List<UserImgVo>> batchGetUserImg(@RequestParam(value="userIdList") List<Long> userIdList, @RequestParam(value="currentUserId", required=false) Long currentUserId) {
        return ResponseEntity.ok((Object)this.forumPostFacadeService.batchGetUserImg(userIdList, currentUserId));
    }

    @GetMapping(value={"getTopicById"})
    @ApiOperation(value="4-95-10 \u6839\u636eid\u83b7\u53d6\u8bdd\u9898\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u8bdd\u9898ID", required=true)})
    public ResponseEntity<TopicFacadeVO> getTopicById(Long id) {
        return ResponseEntity.ok((Object)this.forumPostFacadeService.getTopicById(id));
    }

    @ApiOperation(value="4-95-11 \u83b7\u53d6\u5e16\u5b50\u7b80\u7565\u4fe1\u606f,\u4e0d\u8d70\u8be6\u60c5\u67e5\u8be2\uff08\u592a\u91cd\u4e86\uff09")
    @ApiImplicitParam(name="postId", value="\u5e16\u5b50ID", required=true)
    @GetMapping(value={"lightweight"})
    public ResponseEntity<ForumPostBriefInfoDto> getPostWithoutDetail(@RequestParam(value="postId") Long postId) {
        return ResponseEntity.ok((Object)this.forumPostFacadeService.getBriefInfo(postId));
    }

    @ApiOperation(value="4-95-12 \u53d1\u5e16\u699c")
    @ApiImplicitParam(name="areaCode", value="areaCode", required=true)
    @GetMapping(value={"forumRank"})
    public ResponseEntity<List<ForumRankVo>> forumRank(@RequestParam(value="areaCode") String areaCode, @RequestParam(value="userIds") List<Long> userIds) {
        return ResponseEntity.ok((Object)this.forumPostFacadeService.forumRank(areaCode, userIds));
    }

    @ApiOperation(value="4-95-13 \u4e2a\u4eba\u53d1\u5e16\u699c\u70ed\u5ea6")
    @ApiImplicitParam(name="areaCode", value="areaCode", required=true)
    @GetMapping(value={"forumRankForUser"})
    public ResponseEntity<ForumPostRankForUserVo> forumRankForUser(@RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.forumPostFacadeService.forumRankForUser(userId));
    }

    @GetMapping(value={"getForumPostById"})
    @ApiOperation(value="4-95-14 \u6839\u636eid\u83b7\u53d6\u5e16\u5b50\u4fe1\u606f")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u5e16\u5b50id", required=true)})
    public ResponseEntity<ForumPostVo> getForumPostById(Long id) {
        return ResponseEntity.ok((Object)this.forumPostFacadeService.getForumPostById(id));
    }

    @ApiOperation(value="4-95-15 \u83b7\u53d6\u8bc4\u8bba\u6392\u884c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="areaCode", value="\u5730\u533a\u7f16\u7801"), @ApiImplicitParam(name="limitNum", value="\u622a\u53d6\u6392\u884c\u6761\u6570")})
    @GetMapping(value={"interactRankInfo"})
    public ResponseEntity<List<InteractRankInfo>> getInteractRankInfo(@RequestParam(value="areaCode") String areaCode, @RequestParam(value="limitNum") Integer limitNum, @RequestParam(value="userIds") List<Long> userIds) {
        return ResponseEntity.ok((Object)this.forumPostFacadeService.getInteractRankInfo(areaCode, limitNum.intValue(), userIds));
    }

    @ApiOperation(value="4-95-16 \u83b7\u53d6\u4e2a\u4eba\u8bc4\u8bba\u6570")
    @ApiImplicitParams(value={@ApiImplicitParam(name="userId", value="userId")})
    @GetMapping(value={"replyNumForUser"})
    public ResponseEntity<Integer> replyNumForUser(@RequestParam(value="userId") Long userId) {
        return ResponseEntity.ok((Object)this.forumPostFacadeService.replyNumForUser(userId));
    }
}

