package com.bxm.localnews.news.controller;

import java.util.List;

import com.bxm.localnews.news.dto.CalculateDto;
import com.bxm.localnews.news.dto.CalculatePostDTO;

import com.bxm.localnews.news.service.ForumPostStatisticService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

@Api(tags = "4-93 [内部]帖子静态数据变更", description = "包括推荐、阅读、有效阅读次数...")
@RestController
@RequestMapping("facade/post/statistic")
public class ForumPostStatisticController {

    @Resource
    private ForumPostStatisticService forumPostStatisticService;

    @ApiOperation(value = "4-93-1 帖子推荐次数消费", notes = "对帖子的推荐次数进行消费")
    @PostMapping("recommended")
    public void postRecommendedConsume(@RequestParam(value = "userId") Long userId, @RequestParam(value = "postIds") List<Long> ids) {
        forumPostStatisticService.doConsumeRecommendedCount(ids, userId);
    }

    @ApiOperation(value = "4-93-2 帖子阅读次数消费", notes = "对帖子的阅读次数进行消费")
    @PostMapping("click")
    public void postClickConsume(@RequestParam(value = "userId") Long userId, @RequestParam(value = "postId") Long postId) {
        forumPostStatisticService.doConsumeClickCount(postId, userId);
    }

    @ApiOperation(value = "4-93-3 帖子有效阅读次数消费", notes = "对帖子的有效阅读次数进行消费")
    @PostMapping("active")
    public void postActiveViewConsume(@RequestParam(value = "userId") Long userId, @RequestParam(value = "postId") Long postId) {
        forumPostStatisticService.doConsumeActiveViewCount(postId, userId);
    }

    @ApiOperation(value = "4-93-4 帖子点赞表中未展示的数据更新", notes = "帖子点赞信息同步")
    @PostMapping("refreshLikeInfo")
    public void refreshLikeInfo() {
        forumPostStatisticService.doRefreshLikeInfo();
    }


    @ApiOperation(value = "4-93-4 帖子点赞信息用户昵称,用户头像同步", notes = "帖子点赞信息同步")
    @PostMapping("syncPostLikeInfo")
    public void syncPostLikeInfo() {
        forumPostStatisticService.doSyncPostLikeInfo();
    }

    @ApiOperation(value = "4-93-5 帖子点赞概览,评论概览信息同步", notes = "点赞概览,评论概览信息同步")
    @PostMapping("syncPostStaticInfo")
    public void syncPostStaticInfo() {
        forumPostStatisticService.doSyncPostStaticInfo();
    }

    @ApiOperation(value = "4-93-6 帖子统计最近5分钟用户发帖数量", notes = "统计最近5分分钟用户发帖数量")
    @PostMapping("calculatePostCount")
    public CalculateDto calculatePostCount() {
        List<CalculatePostDTO> postDTOS = forumPostStatisticService.calculatePostCount();
        CalculateDto calculateDto = new CalculateDto();
        calculateDto.setCalculates(postDTOS);
        return calculateDto ;
    }

}
