package com.bxm.localnews.news.controller;

import com.bxm.localnews.news.service.NoteService;
import com.bxm.localnews.news.vo.NoteVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

@Api(tags = "4-99 [内部]小纸条接口")
@RestController
@RequestMapping("facade/note")
public class NoteFacadeController {

    @Resource
    private NoteService noteService;

    @ApiOperation(value = "4-99-1 批量获取用户小纸条")
    @GetMapping("batchGetUserNote")
    public ResponseEntity<List<NoteVo>> batchGetUserNote(@RequestParam(value = "userIdList") List<Long> userIdList,
                                                         @RequestParam(value = "currentUserId", required = false) Long currentUserId) {
        return ResponseEntity.ok(noteService.batchGetUserNote(userIdList, currentUserId));
    }

    @ApiOperation(value = "4-99-2 获取用户小纸条列表")
    @GetMapping("getUserNoteList")
    public ResponseEntity<List<NoteVo>> getUserNoteList(@RequestParam(value = "userId") Long userId) {
        return ResponseEntity.ok(noteService.getUserNoteList(userId));
    }

}
