/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.integration;

import com.bxm.localnews.facade.PushMsgSupplyFeignService;
import com.bxm.localnews.news.param.VideoBlackParam;
import com.bxm.localnews.news.param.VideoShareParam;
import com.bxm.localnews.news.param.VideoViewParam;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class NewsStatisticIntegrationService {
    @Autowired
    PushMsgSupplyFeignService pushMsgSupplyFeignService;

    @Async
    public void pushShareData(Long userId, Long newsId) {
        this.pushMsgSupplyFeignService.pushShareData(userId, newsId);
    }

    @Async
    public void pushViewData(Long userId, Long newsId) {
        this.pushMsgSupplyFeignService.pushViewData(userId, newsId);
    }

    public void pushRecommededData(Long userId, List<Long> newsIdList) {
        List newsIdStr = newsIdList.stream().map(String::valueOf).collect(Collectors.toList());
        String newsIds = String.join((CharSequence)",", newsIdStr);
        this.pushMsgSupplyFeignService.pushRecommededData(userId, newsIds);
    }

    @Async
    public void pushNewClickData(Long userId, Long newsId) {
        this.pushMsgSupplyFeignService.pushNewClickData(userId, newsId);
    }

    @Async
    public void pushCollectData(Long userId, Long newsId, Byte type) {
        this.pushMsgSupplyFeignService.pushCollectData(userId, newsId, type);
    }

    @Async
    public void pushCommentData(Long userId, Long newsId) {
        this.pushMsgSupplyFeignService.pushCommentData(userId, newsId);
    }

    @Async
    public void pushVideoViewData(VideoViewParam videoViewParam) {
        this.pushMsgSupplyFeignService.pushVideoViewData(videoViewParam);
    }

    @Async
    public void pushVideoBlackData(VideoBlackParam videoBlackParam) {
        this.pushMsgSupplyFeignService.pushVideoBlackData(videoBlackParam);
    }

    @Async
    public void pushVideoShareData(VideoShareParam videoShareParam) {
        this.pushMsgSupplyFeignService.pushVideoShareData(videoShareParam);
    }

    @Async
    public void pushVideoCommentData(Long userId, Long newsId) {
        this.pushMsgSupplyFeignService.pushVideoCommentData(userId, newsId);
    }
}

