/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.integration;

import com.bxm.localnews.dto.LocationDTO;
import com.bxm.localnews.facade.LocationFeignService;
import com.bxm.newidea.component.service.BaseService;
import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LocationIntegrationService
extends BaseService {
    @Autowired
    private LocationFeignService locationFeignService;
    private Map<String, LocationDTO> localCacheMap = Maps.newConcurrentMap();
    private long nextRefreshTime = 0L;
    private static final Long CACHE_MILLISECOND = 300000L;

    public LocationDTO getLocationByGeocode(String code) {
        LocationDTO location;
        if (StringUtils.isBlank((CharSequence)code)) {
            this.logger.info("code\u4e3a\u7a7a");
            return new LocationDTO();
        }
        if (System.currentTimeMillis() > this.nextRefreshTime) {
            this.localCacheMap.clear();
            this.nextRefreshTime = System.currentTimeMillis() + CACHE_MILLISECOND;
        }
        if (null == (location = this.localCacheMap.get(code))) {
            location = (LocationDTO)this.locationFeignService.getLocationByGeocode(code).getBody();
            this.localCacheMap.put(code, location);
        }
        return location;
    }
}

