/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.integration;

import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.facade.UserFeignService;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.localnews.vo.VirtualUserInfo;
import com.bxm.newidea.component.service.BaseService;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class UserIntegrationService
extends BaseService {
    @Autowired
    private UserFeignService userFeignService;
    private Map<Long, Byte> virtualUserTypeMap = Maps.newConcurrentMap();
    private long nextRefreshTime = 0L;
    private static final Long CACHE_MILLISECOND = 3600000L;

    public UserBean selectUserFromCache(Long userId) {
        ResponseEntity<UserBean> userBeanResponseEntity = this.userFeignService.selectUserFromCache(userId);
        if (null != userBeanResponseEntity && null != userBeanResponseEntity.getBody()) {
            this.logger.debug("\u8c03\u7528localnews-user\u670d\u52a1\u83b7\u53d6\u7528\u6237\u4fe1\u606f->userId:[{}],\u8fd4\u56de:[{}]", (Object)userId, (Object)JSONObject.toJSONString((Object)userBeanResponseEntity.getBody()));
            return (UserBean)userBeanResponseEntity.getBody();
        }
        return null;
    }

    public Boolean addPostReplyNum(Long userId, Integer type) {
        return (Boolean)this.userFeignService.addPostReplyNum(userId, type).getBody();
    }

    public List<VirtualUserInfo> getVirtualUserList(Integer num) {
        return (List)this.userFeignService.getVirtualUserList(num).getBody();
    }

    @Async
    public Boolean updateUserLikeNumByUserId(Long userId) {
        return (Boolean)this.userFeignService.updateUserLikeNumByUserId(userId).getBody();
    }

    public Byte getVirtualUserType(Long userId) {
        Byte virtualUserType;
        if (null == userId) {
            return (byte)0;
        }
        if (System.currentTimeMillis() > this.nextRefreshTime) {
            this.virtualUserTypeMap.clear();
            this.nextRefreshTime = System.currentTimeMillis() + CACHE_MILLISECOND;
        }
        if (null == (virtualUserType = this.virtualUserTypeMap.get(userId))) {
            virtualUserType = (Byte)this.userFeignService.getVirtualUserType(userId).getBody();
            this.virtualUserTypeMap.put(userId, virtualUserType);
        }
        return virtualUserType;
    }
}

