/*
 * Decompiled with CFR 0.152.
 */
package com.bxm.localnews.integration;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bxm.localnews.facade.MessageFeignService;
import com.bxm.localnews.integration.UserIntegrationService;
import com.bxm.localnews.mq.common.constant.PushMessageEnum;
import com.bxm.localnews.mq.common.constant.TemplateTypeEnum;
import com.bxm.localnews.mq.common.model.dto.PushMessage;
import com.bxm.localnews.mq.common.model.dto.PushPayloadInfo;
import com.bxm.localnews.mq.common.model.dto.PushReceiveScope;
import com.bxm.localnews.news.config.UserProperties;
import com.bxm.localnews.news.domain.ForumPostMapper;
import com.bxm.localnews.news.domain.NewsMapper;
import com.bxm.localnews.news.domain.NewsReplyMapper;
import com.bxm.localnews.news.domain.VideoMapper;
import com.bxm.localnews.news.dto.NewsCompleTaskDTO;
import com.bxm.localnews.news.enums.ReplyTypeEnum;
import com.bxm.localnews.news.factory.impl.ExtendFactory;
import com.bxm.localnews.news.param.NewsReplyLikeParam;
import com.bxm.localnews.news.vo.ForumPostVo;
import com.bxm.localnews.news.vo.MixedRecommendPool;
import com.bxm.localnews.news.vo.News;
import com.bxm.localnews.news.vo.NewsReply;
import com.bxm.localnews.news.vo.PostImgVo;
import com.bxm.localnews.news.vo.UserBean;
import com.bxm.localnews.news.vo.Video;
import com.bxm.newidea.component.service.BaseService;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MessageIntegrationService
extends BaseService {
    @Autowired
    private MessageFeignService messageFeignService;
    @Autowired
    private UserIntegrationService userIntegrationService;
    @Autowired
    private UserProperties userProperties;
    @Autowired
    private ForumPostMapper forumPostMapper;
    @Autowired
    private VideoMapper videoMapper;
    @Autowired
    private NewsMapper newsMapper;
    @Autowired
    private NewsReplyMapper newsReplyMapper;

    public void addMessage(PushMessage pushMessage, Long userId) {
        this.messageFeignService.addMessage(pushMessage, userId);
    }

    public void addMessage(Long shareUserId, Long userId, NewsCompleTaskDTO completeTaskDTO, Long newsId, Byte code, String extendUrl, String extendContent, String newsTitle) {
        String nickname;
        String icon;
        String action;
        String title;
        UserBean userEntity = this.userIntegrationService.selectUserFromCache(userId);
        PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.FORWARDING);
        if (Objects.isNull(userEntity) || com.bxm.newidea.component.tools.StringUtils.isEmpty((CharSequence)userEntity.getWeixin())) {
            action = title = "\u6709\u4eba\u6084\u6084\u9605\u8bfb\u4e86\u4f60\u8f6c\u53d1\u7684\u5185\u5bb9\uff0c\u4ed6\u6ca1\u900f\u9732\u540d\u5b57\uff0c\u5956\u52b1\u4f60" + completeTaskDTO.getGoldNum() + "\u6735\u5c0f\u7ea2\u82b1\uff1b";
            icon = this.userProperties.getDefaultHeadImgUrl();
            nickname = "";
        } else {
            title = userEntity.getNickname() + "\u9605\u8bfb\u4e86\u4f60\u8f6c\u53d1\u7684\u5185\u5bb9\uff0c\u5956\u52b1\u4f60" + completeTaskDTO.getGoldNum() + "\u6735\u5c0f\u7ea2\u82b1\uff1b";
            icon = userEntity.getHeadImg();
            nickname = userEntity.getNickname();
            action = "\u9605\u8bfb\u4e86\u4f60\u8f6c\u53d1\u7684\u5185\u5bb9,\u5956\u52b1" + completeTaskDTO.getGoldNum() + "\u5c0f\u7ea2\u82b1";
        }
        Long msgId = this.nextId();
        info.setMsgId(msgId);
        info.addExtend("msgId", (Object)msgId);
        info.addExtend("newsId", (Object)newsId);
        info.addExtend("title", (Object)title);
        info.addExtend("icon", (Object)icon);
        info.addExtend("nickname", (Object)nickname);
        info.addExtend("action", (Object)action);
        info.addExtend("type", (Object)code);
        info.addExtend("extendUrl", (Object)extendUrl);
        info.addExtend("extendContent", (Object)extendContent);
        info.addExtend("flowerNum", (Object)completeTaskDTO.getGoldNum());
        PushMessage message = PushMessage.build();
        message.setTitle(title);
        message.setContent(newsTitle);
        message.setType(TemplateTypeEnum.NOTIFCTION);
        message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)shareUserId));
        message.setPayloadInfo(info);
        this.messageFeignService.addMessage(message, shareUserId);
        this.logger.debug("\u7528\u6237[{}]\u9605\u8bfb\u4e86\u7528\u6237[{}]\u8f6c\u53d1\u5e16\u5b50\uff0c\u7ed9\u7528\u6237[{}]\u53d1\u9001\u63a8\u9001,\u63a8\u9001\u7c7b\u578b\u4e3a[{}]\uff0c\u63a8\u9001\u7684\u6570\u636e\uff1a[{}]", new Object[]{userId, shareUserId, shareUserId, PushMessageEnum.FORWARDING.getType(), JSON.toJSONString((Object)message)});
    }

    public void pushPostReplyMessage(NewsReply newsReply) {
        UserBean userEntity = this.userIntegrationService.selectUserFromCache(newsReply.getUserId());
        ForumPostVo forumPostVo = this.forumPostMapper.selectByPrimaryKey(newsReply.getNewsId());
        if (null != userEntity && null != forumPostVo && !newsReply.getUserId().equals(forumPostVo.getUserId())) {
            String title = userEntity.getNickname() + "\u7ed9\u4f60\u8bc4\u8bba\u4e86";
            PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.BELONG_POST_REPLY);
            Long msgId = this.nextId();
            info.setMsgId(msgId);
            info.addExtend("msgId", (Object)msgId);
            info.addExtend("newsId", (Object)newsReply.getNewsId());
            info.addExtend("postId", (Object)newsReply.getNewsId());
            info.addExtend("title", (Object)title);
            info.addExtend("icon", (Object)userEntity.getHeadImg());
            info.addExtend("nickname", (Object)userEntity.getNickname());
            info.addExtend("action", (Object)"\u7ed9\u4f60\u8bc4\u8bba\u4e86");
            info.addExtend("type", (Object)newsReply.getType());
            info.addExtend("postTitle", (Object)forumPostVo.getTitle());
            info.addExtend("replyContent", (Object)newsReply.getReplyContent());
            List img = forumPostVo.getPostImgList().stream().filter(e -> StringUtils.equalsIgnoreCase((CharSequence)"IMG", (CharSequence)e.getType())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(img)) {
                info.addExtend("extendUrl", (Object)((PostImgVo)img.get(0)).getImgUrl());
            } else {
                info.addExtend("extendContent", (Object)ExtendFactory.getPostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()));
            }
            PushMessage message = PushMessage.build();
            message.setTitle(title);
            message.setContent(newsReply.getReplyContent());
            message.setType(TemplateTypeEnum.NOTIFCTION);
            message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)forumPostVo.getUserId()));
            message.setPayloadInfo(info);
            this.addMessage(message, forumPostVo.getUserId());
            this.logger.debug("\u7528\u6237[{}]\u8bc4\u8bba\u4e86\u7528\u6237[{}]\u7684\u5e16\u5b50\uff0c\u7ed9\u7528\u6237[{}]\u53d1\u9001\u63a8\u9001,\u63a8\u9001\u7c7b\u578b\u4e3a[{}]\uff0c \n\u63a8\u9001\u7684\u6570\u636e\uff1a[{}]", new Object[]{newsReply.getUserId(), forumPostVo.getUserId(), forumPostVo.getUserId(), PushMessageEnum.BELONG_POST_REPLY.getType(), JSON.toJSONString((Object)message)});
        }
    }

    public void pushNewReplyMessage(NewsReply newsReply, PushMessageEnum pushMessageEnum) {
        UserBean userEntity;
        if (newsReply.getParentId() != 0L && Objects.nonNull(newsReply.getParentUserId()) && newsReply.getParentUserId() != 0L && Objects.nonNull(userEntity = this.userIntegrationService.selectUserFromCache(newsReply.getParentUserId()))) {
            String title = newsReply.getUserNickname() + "\u56de\u590d\u4e86\u4f60\u7684\u8bc4\u8bba";
            PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)pushMessageEnum);
            Long msgId = this.nextId();
            info.setMsgId(msgId);
            info.addExtend("msgId", (Object)msgId);
            info.addExtend("icon", (Object)newsReply.getHeadImg());
            info.addExtend("replyId", (Object)newsReply.getId());
            info.addExtend("title", (Object)title);
            info.addExtend("newsId", (Object)newsReply.getNewsId());
            info.addExtend("type", (Object)newsReply.getType());
            info.addExtend("nickname", (Object)newsReply.getUserNickname());
            info.addExtend("action", (Object)"\u56de\u590d\u4e86\u4f60\u7684\u8bc4\u8bba");
            info.addExtend("replyContent", (Object)newsReply.getReplyContent());
            this.addPushPayloadInfo(newsReply, info);
            PushMessage message = PushMessage.build();
            message.setTitle(title);
            if (newsReply.getDeleteFlag() == 0) {
                message.setContent(newsReply.getReplyContent());
            } else {
                message.setContent("\u8be5\u8bc4\u8bba\u5df2\u5220\u9664\uff01");
            }
            message.setType(TemplateTypeEnum.NOTIFCTION);
            message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)newsReply.getParentUserId()));
            message.setPayloadInfo(info);
            this.logger.info("\u63a8\u9001\u7684message:{}", (Object)JSONObject.toJSONString((Object)message));
            this.addMessage(message, newsReply.getParentUserId());
            this.logger.debug("\u7528\u6237[{}]\u8bc4\u8bba\u4e86\u7528\u6237[{}]\u7684\u5e16\u5b50\uff0c\u7ed9\u7528\u6237[{}]\u53d1\u9001\u63a8\u9001,\u63a8\u9001\u7c7b\u578b\u4e3a[{}]\uff0c \n\u63a8\u9001\u7684\u6570\u636e\uff1a[{}]", new Object[]{newsReply.getUserId(), newsReply.getParentUserId(), newsReply.getParentUserId(), pushMessageEnum.getType(), JSON.toJSONString((Object)message)});
        }
    }

    public void pushPostLikeMessage(ForumPostVo forumPostVo, Long userId, int isOld, int flowerNum) {
        UserBean userEntity = this.userIntegrationService.selectUserFromCache(userId);
        if (null != userEntity && null != forumPostVo && !userId.equals(forumPostVo.getUserId())) {
            String title;
            PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.BELONG_POST_LIKE);
            Long msgId = this.nextId();
            if (isOld == 0) {
                String s = "\u7ed9\u4f60\u70b9\u8d5e\u4e86\uff0c\u9001\u4f60" + flowerNum + "\u6735\u5c0f\u7ea2\u82b1";
                title = userEntity.getNickname() + s;
                info.addExtend("action", (Object)s);
            } else {
                title = userEntity.getNickname() + "\u70b9\u8d5e\u4e86\u4f60\u7684\u5e16\u5b50";
                info.addExtend("action", (Object)"\u70b9\u8d5e\u4e86\u4f60\u7684\u5e16\u5b50");
            }
            info.setMsgId(msgId);
            info.addExtend("msgId", (Object)msgId);
            info.addExtend("postId", (Object)forumPostVo.getId());
            info.addExtend("newsId", (Object)forumPostVo.getId());
            info.addExtend("title", (Object)title);
            info.addExtend("icon", (Object)userEntity.getHeadImg());
            info.addExtend("nickname", (Object)userEntity.getNickname());
            info.addExtend("type", (Object)ReplyTypeEnum.POST_REPLY.getCode());
            info.addExtend("postTitle", (Object)forumPostVo.getTitle());
            info.addExtend("flowerNum", (Object)flowerNum);
            List img = forumPostVo.getPostImgList().stream().filter(e -> StringUtils.equalsIgnoreCase((CharSequence)"IMG", (CharSequence)e.getType())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(img)) {
                info.addExtend("extendUrl", (Object)((PostImgVo)img.get(0)).getImgUrl());
            } else {
                info.addExtend("extendContent", (Object)ExtendFactory.getPostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()));
            }
            PushMessage message = PushMessage.build();
            message.setTitle(title);
            message.setType(TemplateTypeEnum.NOTIFCTION);
            message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)forumPostVo.getUserId()));
            message.setPayloadInfo(info);
            this.addMessage(message, forumPostVo.getUserId());
            this.logger.debug("\u7528\u6237[{}]\u70b9\u8d5e\u4e86\u7528\u6237[{}]\u7684\u5e16\u5b50\uff0c\u7ed9\u7528\u6237[{}]\u53d1\u9001\u63a8\u9001,\u63a8\u9001\u7c7b\u578b\u4e3a[{}]\uff0c \n\u63a8\u9001\u7684\u6570\u636e\uff1a[{}]", new Object[]{userId, forumPostVo.getUserId(), forumPostVo.getUserId(), PushMessageEnum.BELONG_POST_LIKE.getType(), JSON.toJSONString((Object)message)});
        }
    }

    private void addPushPayloadInfo(NewsReply newsReply, PushPayloadInfo info) {
        if (newsReply.getType() == 3) {
            ForumPostVo forumPostVo = this.forumPostMapper.selectByPrimaryKey(newsReply.getNewsId());
            List img = forumPostVo.getPostImgList().stream().filter(e -> com.bxm.newidea.component.tools.StringUtils.equalsIgnoreCase((CharSequence)"IMG", (CharSequence)e.getType())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(img)) {
                info.addExtend("extendUrl", (Object)((PostImgVo)img.get(0)).getImgUrl());
            } else {
                info.addExtend("extendContent", (Object)ExtendFactory.getPostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField()));
            }
        } else if (newsReply.getType() == 2) {
            Video video = this.videoMapper.selectByPrimaryKey(newsReply.getNewsId());
            String videoImg = video.getVideoImg();
            if (com.bxm.newidea.component.tools.StringUtils.isNotBlank((CharSequence)videoImg)) {
                info.addExtend("extendUrl", (Object)videoImg);
            } else {
                info.addExtend("extendContent", (Object)ExtendFactory.getContent((String)video.getTitle(), null));
            }
        } else if (newsReply.getType() == 1) {
            News news = this.newsMapper.selectByPrimaryKey(newsReply.getNewsId());
            String imgUrl = news.getImgUrl();
            List imags = JSONObject.parseArray((String)imgUrl, String.class);
            if (!CollectionUtils.isEmpty((Collection)imags)) {
                info.addExtend("extendUrl", imags.get(0));
            } else {
                info.addExtend("extendContent", (Object)ExtendFactory.getContent((String)news.getTitle(), (String)news.getContent()));
            }
        }
    }

    public void pushNewLikeMessage(NewsReplyLikeParam newsReplyLikeParam, PushMessageEnum pushMessageEnum, NewsReply newsReply) {
        UserBean userEntity;
        if (newsReplyLikeParam.getUserId() != 0L && Objects.nonNull(userEntity = this.userIntegrationService.selectUserFromCache(newsReplyLikeParam.getUserId()))) {
            UserBean user = userEntity;
            String title = user.getNickname() + "\u70b9\u8d5e\u4e86\u4f60\u7684\u8bc4\u8bba";
            PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)pushMessageEnum);
            Long msgId = this.nextId();
            info.setMsgId(msgId);
            info.addExtend("msgId", (Object)msgId);
            info.addExtend("icon", (Object)user.getHeadImg());
            info.addExtend("replyId", (Object)newsReplyLikeParam.getReplyId());
            info.addExtend("title", (Object)title);
            if (null != newsReplyLikeParam.getNewsId()) {
                info.addExtend("newsId", (Object)newsReplyLikeParam.getNewsId());
                newsReply = this.newsReplyMapper.selectByPrimaryKeyAndNewsId(newsReplyLikeParam.getReplyId(), newsReplyLikeParam.getNewsId());
            } else {
                newsReply = this.newsReplyMapper.selectByPrimaryKey(newsReplyLikeParam.getReplyId());
            }
            info.addExtend("type", (Object)newsReply.getType());
            info.addExtend("nickname", (Object)user.getNickname());
            info.addExtend("action", (Object)"\u70b9\u8d5e\u4e86\u4f60\u7684\u8bc4\u8bba");
            info.addExtend("replyContent", (Object)newsReply.getReplyContent());
            this.addPushPayloadInfo(newsReply, info);
            PushMessage message = PushMessage.build();
            message.setTitle(title);
            if (newsReply.getDeleteFlag() == 0) {
                message.setContent(newsReply.getReplyContent());
            } else {
                message.setContent("\u8be5\u8bc4\u8bba\u5df2\u5220\u9664!");
            }
            message.setType(TemplateTypeEnum.NOTIFCTION);
            message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)newsReply.getUserId()));
            message.setPayloadInfo(info);
            this.addMessage(message, newsReply.getUserId());
            this.logger.debug("\u7528\u6237[{}]\u70b9\u8d5e\u4e86\u7528\u6237[{}]\u7684\u8bc4\u8bba\uff0c\u7ed9\u7528\u6237[{}]\u53d1\u9001\u63a8\u9001,\u63a8\u9001\u7c7b\u578b\u4e3a[{}]\uff0c \n\u63a8\u9001\u7684\u6570\u636e\uff1a[{}]", new Object[]{newsReplyLikeParam.getUserId(), newsReply.getUserId(), newsReply.getUserId(), pushMessageEnum.getType(), JSON.toJSONString((Object)message)});
        }
    }

    public void pushPostAddRecommendPool(ForumPostVo forumPostVo, MixedRecommendPool recommendPool) {
        UserBean userEntity = this.userIntegrationService.selectUserFromCache(forumPostVo.getUserId());
        if (null != userEntity) {
            String extendContent = ExtendFactory.getPostContent((String)forumPostVo.getTitle(), (String)forumPostVo.getTextField());
            String title = Objects.nonNull(recommendPool.getOptimizationNotice()) && recommendPool.getOptimizationNotice() == 1 ? "\u4f60\u53d1\u5e03\u7684\u3010" + extendContent + "\u3011\u88ab\u5c0f\u7f16\u4f18\u5316\u540e\u63a8\u5230\u5934\u6761\u5566\uff0c\u5956\u52b1\u4f6060\u6735\u5c0f\u7ea2\u82b1\uff0c\u4f60\u7684\u5185\u5bb9\u5c06\u4f1a\u88ab\u66f4\u591a\u4eba\u770b\u5230\u54e6~" : "\u4f60\u53d1\u5e03\u7684\u3010" + extendContent + "\u3011\u88ab\u5c0f\u7f16\u63a8\u5230\u5934\u6761\u5566\uff0c\u5956\u52b1\u4f6060\u6735\u5c0f\u7ea2\u82b1\uff0c\u4f60\u7684\u5185\u5bb9\u5c06\u4f1a\u88ab\u66f4\u591a\u4eba\u770b\u5230\u54e6~";
            PushPayloadInfo info = PushPayloadInfo.build((PushMessageEnum)PushMessageEnum.POST_ADD_RECOMMAND);
            Long msgId = this.nextId();
            info.setMsgId(msgId);
            info.addExtend("msgId", (Object)msgId);
            info.addExtend("postId", (Object)forumPostVo.getId());
            PushMessage message = PushMessage.build();
            message.setTitle("");
            message.setContent(title);
            message.setType(TemplateTypeEnum.NOTIFCTION);
            message.setPushReceiveScope(PushReceiveScope.pushSignle((Long)forumPostVo.getUserId()));
            message.setPayloadInfo(info);
            this.addMessage(message, forumPostVo.getUserId());
            this.logger.debug("\u5e16\u5b50[{}]\u52a0\u5165\u63a8\u8350\u5e93\uff0c\u7ed9\u7528\u6237[{}]\u53d1\u9001\u63a8\u9001,\u63a8\u9001\u7c7b\u578b\u4e3a[{}]\uff0c \n\u63a8\u9001\u7684\u6570\u636e\uff1a[{}]", new Object[]{forumPostVo.getId(), forumPostVo.getUserId(), PushMessageEnum.POST_ADD_RECOMMAND.getType(), JSON.toJSONString((Object)message)});
        }
    }
}

